package com.huigou.topsun.sap.common.application.impl;

import cn.hutool.core.bean.BeanUtil;
import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.common.application.SapMutualEpLogApplication;
import com.huigou.topsun.sap.common.domain.SapMutualEpLog;
import com.huigou.topsun.sap.common.domain.query.MutualEpLogQueryRequest;
import com.huigou.topsun.sap.common.repository.SapMutualEpLogRepository;
import com.huigou.topsun.sap.nonProdApply.domain.query.NonProdApplyBaseInfoQueryRequest;
import com.huigou.uasp.bpm.FlowBroker;
import com.huigou.util.ClassHelper;
import com.huigou.util.DateUtil;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;


@Service("sapMutualEpLogApplication")
public class SapMutualEpLogApplicationImpl extends FlowBroker implements SapMutualEpLogApplication {

    @Autowired
    SapMutualEpLogRepository sapMutualEpLogRepository;

    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public SapMutualEpLog saveSapMutualEpLog(Map<String, Object> map){
        SapMutualEpLog sapMutualEpLog = new SapMutualEpLog();
        try {
            sapMutualEpLog.setBusinessId(map.get("businessId")!=null?map.get("businessId").toString():"");
            sapMutualEpLog.setBusinessType(map.get("businessType")!=null?map.get("businessType").toString():"");
            sapMutualEpLog = ClassHelper.fromMap(SapMutualEpLog.class, map);
            String message = map.get("MESSAGE")!=null?map.get("MESSAGE").toString():"";
            sapMutualEpLog.setMessage(message);
            sapMutualEpLog.setType(map.get("TYPE")!=null?map.get("TYPE").toString():"");
            //BeanUtil.mapToBean(map, ClassHelpersapMutualEpLog);
            Date date = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

            sapMutualEpLog.setCreatedDate(sdf.format(date));
            sapMutualEpLogRepository.save(sapMutualEpLog);
        }catch (Exception ex){
            sapMutualEpLog.setMessage(sapMutualEpLog.getMessage()+":保存日志:"+ex.getMessage());
            sapMutualEpLogRepository.save(sapMutualEpLog);
            ex.printStackTrace();
        }
        return sapMutualEpLog;
    }

    @Override
    public Map<String, Object> slicedMutualEpLogQuery(MutualEpLogQueryRequest query) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "slicedMutualEpLogQuery");
        QueryModel model = this.sqlExecutorDao.getQueryModel(queryDescriptor, query);
       if (StringUtil.isNotBlank(query.getBusinessType())) {
            model.addCriteria(" and  business_type like:BusinessType");
            model.putLikeParam("BusinessType", query.getBusinessType());
        }
        if (StringUtil.isNotBlank(query.getType())) {
            model.addCriteria(" and  type=:type");
            model.putParam("type", query.getType());
        }
        if (StringUtil.isNotBlank(query.getMessage())) {
            model.addCriteria(" and  message like:message");
            model.putLikeParam("message", query.getMessage());
        }
        if (StringUtil.isNotBlank(query.getParameter())) {
            model.addCriteria(" and  parameter like:parameter");
            model.putLikeParam("parameter", query.getParameter());
        }
        //  model.putDictionary("maintenanceType", DictUtil.getDictionary("maintainType"));

        model.setSortFieldName("createdDate");
        model.setSortOrder("desc");
        return this.sqlExecutorDao.executeSlicedQuery(model);
    }

    @Override
    public List<SapMutualEpLog> findByBusinessId(String businessId) {
        return sapMutualEpLogRepository.findByBusinessId(businessId);
    }

}
