package com.huigou.topsun.sap.clientMaterials.controller;

import com.huigou.topsun.sap.clientMaterials.application.ClientMaterialsApplication;
import com.huigou.topsun.sap.clientMaterials.domain.ClientMaterials;
import com.huigou.topsun.sap.clientMaterials.domain.query.ClientMaterialsQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.JSONUtil;
import com.huigou.util.SDO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.Date;
import java.util.Map;

/**客户供料通知
 * @Auther: LXH
 * @Date: 2024/06/05 10:15
 * @Description:
 */
@Controller
@ControllerMapping("/clientMaterials")
public class ClientMaterialsController extends CommonController {
    private final static Logger LOG = LoggerFactory.getLogger(ClientMaterialsController.class);
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/clientMaterials/";
    }

    @Resource
    private ClientMaterialsApplication clientMaterialsApplication;

    public String forwardClientMaterialsList(){
        return forward("clientMaterialsList");
    }

    public String slicedClientMaterialsList(){
        SDO sdo = this.getSDO();
        ClientMaterialsQueryRequest queryRequest = sdo.toQueryRequest(ClientMaterialsQueryRequest.class);
        Map<String, Object> map = clientMaterialsApplication.getClientMaterialsList(queryRequest);
        return toResult(map);
    }

    /**
     * 删除组件补充发料
     */
    public String deleteClientMaterials() {
        SDO sdo = this.getSDO();
        String row = sdo.getString("row");
        ClientMaterials materials = JSONUtil.toBean(row, ClientMaterials.class);
        String personMemberName = sdo.getOperator().getPersonMemberName();
        String personMemberId = sdo.getOperator().getPersonMemberId();
        materials.setDeleteTime(new Date());
        materials.setDeletePersonMemberId(personMemberId);
        materials.setDeletePersonMemberName(personMemberName);
        clientMaterialsApplication.deleteFromSap(materials);
        return success();
    }


}
