package com.huigou.topsun.sap.cashSettlementUnPay.controller;

import com.huigou.topsun.sap.cashSettlementUnPay.application.CashSettlementUnPayItemApplication;
import com.huigou.topsun.sap.cashSettlementUnPay.application.CashSettlementUnPayItemDetailApplication;
import com.huigou.topsun.sap.cashSettlementUnPay.domain.CashSettlementUnPayItemDetail;
import com.huigou.topsun.sap.cashSettlementUnPay.domain.query.CashSettlementUnPayQueryRequest;
import com.huigou.topsun.sap.cashSettlementUnPay.vo.CashSettlementUnPayItemDetailVo;
import com.huigou.topsun.sap.cashSettlementUnPay.vo.CashSettlementUnPayItemVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.ClassHelper;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date:  2024/03/26 10:10
 * @Description:
 */
@Controller
@ControllerMapping("/cashSettlementUnPayItem")
public class CashSettlementUnPayItemController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/cashSettlementUnPay/";
    }
    @Autowired
    private CashSettlementUnPayItemApplication cashSettlementUnPayItemApplication;
    @Autowired
    private CashSettlementUnPayItemDetailApplication cashSettlementUnPayItemDetailApplication;

    public String queryCashSettlementUnPayItems(){
        SDO sdo = this.getSDO();
        CashSettlementUnPayQueryRequest queryRequest = sdo.toQueryRequest(CashSettlementUnPayQueryRequest.class);
        Map<String, Object> map = cashSettlementUnPayItemApplication.queryCashSettlementUnPayItems(queryRequest);
        return toResult(map);
    }

    public String deleteCashSettlementUnPayItems(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        cashSettlementUnPayItemApplication.deleteByIds(ids);
        return success();
    }

    public String getItemDetailsByAdvanceReceiptNo(){
        SDO sdo = this.getSDO();
        String advanceReceiptNo = sdo.getString("advanceReceiptNo");
        List<CashSettlementUnPayItemDetailVo> detailVoList = cashSettlementUnPayItemDetailApplication.getItemDetailsByAdvanceReceiptNo(advanceReceiptNo);
        List<CashSettlementUnPayItemDetail> detailList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(detailVoList)){
            for (CashSettlementUnPayItemDetailVo itemDetailVo : detailVoList) {
                CashSettlementUnPayItemDetail itemDetail = new CashSettlementUnPayItemDetail();
                ClassHelper.copyProperties(itemDetailVo,itemDetail);
                detailList.add(itemDetail);
            }
        }
        return packGridDataAndResult(detailList);
    }

    public String getItemDetailsByAdvanceReceiptNoOrSaleNo(){
        SDO sdo = this.getSDO();
        String advanceReceiptNo = sdo.getString("advanceReceiptNo");
        String saleNo = sdo.getString("saleNo");
        List<CashSettlementUnPayItemDetailVo> detailVoList = cashSettlementUnPayItemDetailApplication.getItemDetailsByAdvanceReceiptNoOrSaleNo(advanceReceiptNo,saleNo);
        List<CashSettlementUnPayItemDetail> detailList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(detailVoList)){
            for (CashSettlementUnPayItemDetailVo itemDetailVo : detailVoList) {
                CashSettlementUnPayItemDetail itemDetail = new CashSettlementUnPayItemDetail();
                ClassHelper.copyProperties(itemDetailVo,itemDetail);
                detailList.add(itemDetail);
            }
        }
        return packGridDataAndResult(detailList);
    }

    public String showItemDetail() {
        SDO sdo = this.getSDO();
        String advanceReceiptNo = sdo.getString("advanceReceiptNo");
        CashSettlementUnPayItemVo vo = cashSettlementUnPayItemDetailApplication.getItemByAdvanceReceiptNo(advanceReceiptNo);
        return forward("advanceReceiptNoDetail", vo);
    }

    public String showReceiptNoDetail() {
        SDO sdo = this.getSDO();
        String customerCode = sdo.getString("customerCode");
        this.putAttribute("customerCode",customerCode);
        return forward("showReceiptNoDetail");
    }

    public String updateCashSettlementUnPayItems() {
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        String advanceReceiptNo = sdo.getString("advanceReceiptNo");
        cashSettlementUnPayItemApplication.updateCashSettlementUnPayItem(id,advanceReceiptNo);
        return success();
    }

}
