package com.huigou.topsun.sap.cashSettlementUnPay.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.cashSettlementUnPay.application.CashSettlementUnPayApplication;
import com.huigou.topsun.sap.cashSettlementUnPay.application.CashSettlementUnPayItemApplication;
import com.huigou.topsun.sap.cashSettlementUnPay.domain.CashSettlementUnPay;
import com.huigou.topsun.sap.cashSettlementUnPay.domain.query.CashSettlementUnPayQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.tool.dataimport.application.ExcelImportApplication;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 现结未付款发货审批
 */
@Controller
@ControllerMapping("/cashSettlementUnPay")
public class CashSettlementUnPayController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/cashSettlementUnPay/";
    }

    @Resource
    private CashSettlementUnPayApplication cashSettlementUnPayApplication;
    @Autowired
    private CashSettlementUnPayItemApplication cashSettlementUnPayItemApplication;

    public String forwardCashSettlementUnPayList(){
        return forward("cashSettlementUnPayList");
    }

    public String slicedCashSettlementUnPayList(){
        SDO sdo = this.getSDO();
        CashSettlementUnPayQueryRequest queryRequest = sdo.toQueryRequest(CashSettlementUnPayQueryRequest.class);
        Map<String, Object> map = cashSettlementUnPayApplication.getCashSettlementUnPayList(queryRequest);
        return toResult(map);
    }

    public String forwardCashSettlementUnPayDetail(){
        this.putAttribute("processDefinitionKey", CashSettlementUnPayApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        CashSettlementUnPay cashSettlementUnPay = new CashSettlementUnPay();
        cashSettlementUnPay.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        cashSettlementUnPay.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("cashSettlementUnPayDetail", cashSettlementUnPay);
    }

    public String showCashSettlementUnPay(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        CashSettlementUnPay cashSettlementUnPay = cashSettlementUnPayApplication.getCashSettlementUnPayById(id);
        return forward("cashSettlementUnPayDetail", cashSettlementUnPay);
    }

}
