package com.huigou.topsun.mes.unqualifiedMaterials.domain.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Auther: xin.lu
 * @Date: 2024/08/12/10:25
 * @Description: 质量异常评审表
 */
@Data
public class UnqualifiedMaterialsVo implements Serializable {
    /**
     * 物料凭证号
     */
    @JsonProperty("MBLNR")
    private String mblnr;

    /**
     * 凭证项次
     */
    @JsonProperty("ZEILE")
    private String zeile;

    /**
     * 凭证年份
     */
    @JsonProperty("MJAHR")
    private String mjahr;
    /**
     * 产品名称
     */
    @JsonProperty("productName")
    private String productName;

    /**
     * 类别
     */
    @JsonProperty("type")
    private String type;

    /**
     * 生产批次
     */
    @JsonProperty("batchNo")
    private String batchNo;

    /**
     * PD/YL编码
     */
    @JsonProperty("pd")
    private String pd;

    /**
     * 部门/工序
     */
    @JsonProperty("process")
    private String process;

    /**
     * 异常数量
     */
    @JsonProperty("exceptionNum")
    private BigDecimal exceptionNum;

    /**
     * 异常描述
     */
    @JsonProperty("exceptionDesc")
    private String exceptionDesc;

    /**
     * 责任部门
     */
    @JsonProperty("dutyDept")
    private String dutyDept;

    /**
     * 责任部门
     */
    @JsonProperty("dutyDeptName")
    private String dutyDeptName;

    /**
     * 提报人
     */
    @JsonProperty("submitter")
    private String submitter;

    /**
     * 提报人
     */
    @JsonProperty("submitterName")
    private String submitterName;

    /**
     * 采购单号
     */
    @JsonProperty("purchaseOrderNo")
    private String purchaseOrderNo;

    /**
     * 仓管员
     */
    @JsonProperty("username")
    private String usnam;

    /**
     * sap订单类型
     */
    @JsonProperty("orderType")
    private String orderType;

    /**
     * 数量
     */
    @JsonProperty("quantity")
    private String quantity;

    /**
     * 供应商名称
     */
    @JsonProperty("vendorName")
    private String vendorName;

    /**
     * 供应商编码
     */
    @JsonProperty("vendorCode")
    private String vendorCode;
}
