package com.huigou.topsun.ep.order.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/20/09:16
 * @Description: EP销售订单取消/变更
 */
@Data
@Entity
@Table(name = "ep_sale_order_cancel")
public class EpSaleOrderCancel extends FlowBillAbstractEntity {
    /**
     * 订单类型
     */
    @Column(name = "order_type")
    private String orderType;

    /**
     * 订单类型描述
     */
    @Column(name = "order_type_name")
    private String orderTypeName;

    /**
     * 客户编码
     */
    @Column(name = "customer_code")
    private String customerCode;

    /**
     * 客户名称
     */
    @Column(name = "customer_name")
    private String customerName;

    /**
     * 产品类型
     */
    @Column(name = "product_type")
    private String productType;

    /**
     * 原订单是否取消(1取消，2变更)
     */
    @Column(name = "is_cancel")
    private String isCancel;

    /**
     * 修改内容
     */
    @Column(name = "update_context")
    private String updateContext;

    /**
     * 客户协商结论
     */
    @Column(name = "consult_conclusion")
    private String consultConclusion;

    /**
     * 评审结论
     */
    @Column(name = "review_conclusion")
    private String reviewConclusion;

    @Column(name = "code")
    private String code;

    @Column(name = "msg")
    private String msg;


    @Override
    protected String getCodeRuleId() {
        return "epSaleOrderCancel";
    }
}
