package com.huigou.topsun.ep.order.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.common.CommonUtils;
import com.huigou.topsun.ep.order.application.EpSaleOrderApplication;
import com.huigou.topsun.ep.order.domain.EpSaleOrder;
import com.huigou.topsun.ep.order.domain.query.EpSaleOrderQueryRequest;
import com.huigou.topsun.ep.order.domain.vo.EpSaleOrderVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.ClassHelper;
import com.huigou.util.JSONUtil;
import com.huigou.util.SDO;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/12/19:13
 * @Description:
 */
@Controller
@ControllerMapping("/epSaleOrder")
public class EpSaleOrderController extends CommonController {

    private final static Logger LOG = LoggerFactory.getLogger(EpSaleOrderController.class);
    @Override
    protected String getPagePath() {
        return "/biz/topsun/ep/epSaleOrder/";
    }

    @Resource
    private EpSaleOrderApplication epSaleOrderApplication;

    public String forwardEpSaleOrderList(){
        return forward("epSaleOrderList");
    }

    public String slicedEpSaleOrderList(){
        SDO sdo = this.getSDO();
        EpSaleOrderQueryRequest queryRequest = sdo.toQueryRequest(EpSaleOrderQueryRequest.class);
        Map<String, Object> map = epSaleOrderApplication.slicedEpSaleOrderList(queryRequest);
        return toResult(map);
    }

    public String forwardEpSaleOrderDetail(){
        this.putAttribute("processDefinitionKey", EpSaleOrderApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        EpSaleOrder epSaleOrder = new EpSaleOrder();
        epSaleOrder.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        epSaleOrder.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("epSaleOrderDetail",epSaleOrder);
    }

    public String showEpSaleOrderDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        EpSaleOrder epSaleOrder = epSaleOrderApplication.findEpSaleOrderById(id);
        return forward("epSaleOrderDetail",epSaleOrder);
    }

    @SkipAuth
    @RequestMapping( value = "/getEpSaleOrder")
    @ResponseBody
    public HashMap<String, Object> getEpSaleOrder(@RequestBody List<EpSaleOrderVo> epSaleOrderVos){
        //SDO sdo = this.getSDO();
        HashMap<String, Object> messageMap = new HashMap<>();
        messageMap.put("Message_Status","S");
        messageMap.put("Message_Text","成功");
        LOG.info("EP销售订单审批数据=={}", JSONUtil.toString(epSaleOrderVos));
        try {
            this.epSaleOrderApplication.saveEpSaleOrderVo(epSaleOrderVos);
        }catch (RuntimeException e){
            messageMap.put("Message_Status","E");
            messageMap.put("Message_Text",e.getMessage());
        }
        return messageMap;
    }

    /**
     * 打印
     * @return
     */
    public String print() {
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        Map<String,Object> map = epSaleOrderApplication.print(id);
        String pintPage = String.format("/print/topsun/backSaleOrder.ftl");
        return outputAndProcUnitHandlerPDF(pintPage, id, map);
    }
}
