package com.huigou.topsun.ep.order.controller;

import com.huigou.topsun.ep.order.application.EpSaleOrderCancelItemApplication;
import com.huigou.topsun.ep.order.domain.query.EpSaleOrderCancelQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/12/19:14
 * @Description:
 */
@Controller
@ControllerMapping("/epSaleOrderCancelItem")
public class EpSaleOrderCancelItemController extends CommonController {
    @Resource
    private EpSaleOrderCancelItemApplication epSaleOrderCancelItemApplication;

    public String queryEpSaleOrderCancelItems(){
        SDO sdo = this.getSDO();
        EpSaleOrderCancelQueryRequest queryRequest = sdo.toQueryRequest(EpSaleOrderCancelQueryRequest.class);
        Map<String, Object> map = epSaleOrderCancelItemApplication.queryEpSaleOrderCancelItems(queryRequest);
        return toResult(map);
    }

    public String deleteEpSaleOrderCancelItem(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        epSaleOrderCancelItemApplication.deleteByIds(ids);
        return success();
    }
}
