package com.huigou.topsun.ep.change.application.impl;

import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.ep.change.application.EpChangeFormStockItemApplication;
import com.huigou.topsun.ep.change.domain.EpChangeFormStockItem;
import com.huigou.topsun.ep.change.domain.query.EpChangeFormQueryRequest;
import com.huigou.topsun.ep.change.repository.EpChangeFormStockItemRepository;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/06/19/11:45
 * @Description:
 */
@Service("epChangeFormStockItemApplication")
public class EpChangeFormStockItemApplicationImpl extends BaseApplication implements EpChangeFormStockItemApplication {
    @Autowired
    private EpChangeFormStockItemRepository changeFormStockItemRepository;
    @Override
    public Map<String,Object> findByEpChangeFormId(EpChangeFormQueryRequest queryRequest) {
        Map<String,Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getEpChangeFormId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "epChangeFormStockItem");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            queryModel.putDictionary("confirm", DictUtil.getDictionary("confirm"));
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void saveEpChangeFormStockItems(String epChangeFormId, List<EpChangeFormStockItem> epChangeFormStockItems) {
        for (EpChangeFormStockItem epChangeFormStockItem : epChangeFormStockItems) {
            epChangeFormStockItem.setEpChangeFormId(epChangeFormId);
        }
        changeFormStockItemRepository.save(epChangeFormStockItems);
    }

    @Override
    public void deleteItems(List<String> ids) {
        for (String id : ids) {
            changeFormStockItemRepository.delete(id);
        }
    }

    @Override
    public Map<String, Object> findByOldId(EpChangeFormQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "epChangeFormStockItemByOldId");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
        queryModel.putDictionary("confirm", DictUtil.getDictionary("confirm"));
        return this.sqlExecutorDao.executeSlicedQuery(queryModel);
    }
}
