package com.huigou.topsun.dataSource;

import com.huigou.util.StringUtil;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;


public class DynamicDataSource extends AbstractRoutingDataSource {

    /**
     * 获取与数据源相关的key 此key是Map<String,DataSource> resolvedDataSources 中与数据源绑定的key值
     * 在通过determineTargetDataSource获取目标数据源时使用
     */
    @Override
    protected Object determineCurrentLookupKey() {
        String dataSource = HandleDataSource.getDataSource();
        if (StringUtil.isNotBlank(dataSource)){
            System.out.println("——————————切换的数据源是：——————————"+dataSource);
        }
        return dataSource;
    }
}