package com.huigou.topsun.base.bsnMessage.domain;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 驳回信息实体
 * @TableName bsn_message_reject
 */
@Table(name="bsn_message_reject")
@Entity
@Data
public class BsnMessageReject implements Serializable {
    /**
     * 
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "id")
    private String id;

    /**
     * 
     */
    @Column(name = "bsn_execute_id")
    private String bsnExecuteId;

    /**
     * 驳回信息
     */
    @Column(name = "reject_msg")
    private String rejectMsg;

    /**
     * 驳回时间
     */
    @Column(name = "reject_date")
    private Date rejectDate;

    /**
     * 处理时间
     */
    @Column(name = "rectify_date")
    private Date rectifyDate;

//    /**
//     * 处理状态
//     */
//    @Column(name = "rectify_status")
//    private Date rectifyStatus;

    private static final long serialVersionUID = 1L;
}