package com.huigou.topsun.base.bsnMessage.domain;

import lombok.Data;
import org.apache.http.annotation.Contract;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 任务执行实体
 * @TableName bsn_message_execute
 */
@Table(name="bsn_message_execute")
@Entity
@Data
public class BsnMessageExecute implements Serializable {
    /**
     * 
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    private String id;

    /**
     * 
     */
    @Column(name = "message_sponsor_id")
    private String messageSponsorId;

    /**
     * 任务描述
     */
    @Column(name = "task_describe")
    private String taskDescribe;

    /**
     * 任务执行人
     */
    @Column(name = "task_execute")
    private String taskExecute;

    /**
     * 业务应用类型
     */
    @Column(name = "business_code")
    private String businessCode;

    /**
     * 更新日期
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 完成日期
     */
    @Column(name = "finished_date")
    private Date finishedDate;

    /**
     * 完成状态（默认为未完成：0，完成为：1, 保存未分发为：2，驳回为：3）
     */
    private Integer active;

    @Transient
    private List<BsnMessageReject> rejects;

    public void addReject(BsnMessageReject reject){
        if(this.rejects==null){
            this.rejects = new ArrayList<>();
        }
        rejects.add(reject);
    }

    private static final long serialVersionUID = 1L;

}