package com.huigou.topsun.base.bsnMessage.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.base.bsnMessage.appliction.BsnMessageApplication;
import com.huigou.topsun.base.bsnMessage.domain.query.BsnMessageQueryRequest;
import com.huigou.topsun.sap.costCenter.application.CostCenterApplication;
import com.huigou.topsun.sap.costCenter.domain.CostCenter;
import com.huigou.topsun.sap.costCenter.domain.query.CostCenterQueryRequest;
import com.huigou.topsun.sap.costCenter.domain.vo.CostCenterVo;
import com.huigou.uasp.annotation.ControllerMapping;

import com.huigou.uasp.client.CommonController;
import com.huigou.util.DateUtil;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Controller;



/**
 * @Auther: lxh
 * @Date: 2024/04/13/11:36
 * @Description:
 */
@Controller
@ControllerMapping("/bsnMessage")
public class BsnMessageController extends CommonController {

    @Autowired
    private BsnMessageApplication bsnMessageApplication;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/base/";
    }


    /**
     * 跳转到任务中心查询列表
     *
     * @return
     */
    public String forwardBsnMessage() {

        return forward("bsnMessageList");
    }

    public String slicedBsnMessageList() {
        SDO sdo = this.getSDO();

        BsnMessageQueryRequest  queryRequest= sdo.toQueryRequest(BsnMessageQueryRequest.class);
        return toResult(bsnMessageApplication.queryExecuteBsnMessage(queryRequest));
    }


}
