package com.huigou.topsun.base.bsnMessage.appliction;

import com.huigou.topsun.base.bsnMessage.domain.BsnMessageExecute;
import com.huigou.topsun.base.bsnMessage.domain.BsnMessageReject;
import com.huigou.topsun.base.bsnMessage.domain.BsnMessageSponsor;
import com.huigou.topsun.base.bsnMessage.domain.query.BsnMessageQueryRequest;
import com.huigou.uasp.bmp.bizconfig.model.ObjectKindEnum;

import java.util.List;
import java.util.Map;

public interface BsnMessageApplication {

    String QUERY_XML_FILE_PATH = "config/topsun/base/bsnMessage.xml";


    /**
     * 保存任务
     * @param bsnMessageSponsor
     */
    String keepTasks(BsnMessageSponsor bsnMessageSponsor);

    void saveBsnMessageExecute(List<BsnMessageExecute> all);
    /**
     * 发布任务
     * @param bId 表单单号
     */
    void publishTasks(String bId);

    /**
     * 保存并发布任务
     */
    void keepAndPublishTasks(BsnMessageSponsor bsnMessageSponsor);

    /**
     * 发布人驳回任务
     * @param exMap put("驳回部门","驳回信息")
     * @param mId 表单id
     */
    void rejectTasksByMeId(Map<String ,Object> exMap,String meId);

    /**
     * 发布人驳回任务
     * @param exMap put("驳回部门","驳回信息")
     * @param bId 表单id
     */
    void rejectTasksByBId(Map<String ,Object> exMap,String bId);

    /**
     * 发布人批准任务
     */
    void authorizeTasks(String bId);


    /**
     * 执行人提交任务
     * @param meId
     */
    void submitTask(String meId);


    /**
     * 任务流转
     */
    Map<String, Object> circulate(String meId);



    /**
     * 获取当前登录用户未完成或被驳回的任务
     * @return 任务执行的详细信息集合
     */
     Map<String,Object> queryExecuteBsnMessage();

     Map<String, Object> queryExecuteBsnMessage(BsnMessageQueryRequest query);

    /**
     * 当前登录用户是否以任务发起人的身份发起过任务如果有
     * 且分发到的各单位已完成处理，则返回该任务
     * @return 任务发起的详细信息集合
     */
    List<BsnMessageSponsor> queryFinishBsnMessageSponsor();

    /**
     * 根据任务发布Id，获取该流程下是否所有执行单位已就绪。若就绪返回审批任务
     * @param msId
     * @return
     */
    BsnMessageExecute isExecutesReady(String msId);


    String saveBsnMessageSponsor(BsnMessageSponsor entity);


    /**
     * 根据任务执行id获取驳回信息
     * @param meId
     * @return
     */
    List<BsnMessageReject>  getRejectDetail(String meId);

    void deleteByBusinessId(String businessId);
}
