package com.huigou.topsun.base.attachmentExplain.controller;

import com.huigou.topsun.base.attachmentExplain.application.AttachmentExplainApplication;
import com.huigou.topsun.base.attachmentExplain.domain.model.AttachmentExplain;
import com.huigou.topsun.base.attachmentExplain.domain.query.AttachmentExplainQueryRequest;
import com.huigou.topsun.common.YesOrNo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.log.annotation.LogInfo;
import com.huigou.uasp.log.domain.model.LogType;
import com.huigou.uasp.log.domain.model.OperationType;
import com.huigou.util.SDO;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;

/**
 * 附件上传说明控制层
 * 
 * @ClassName: AttachmentExplainController
 * @author
 * @date 2018-04-02 14:20
 * @version V1.0
 */
@Controller
@ControllerMapping("attachmentExplain")
public class AttachmentExplainController extends CommonController {

    @Autowired
    private AttachmentExplainApplication attachmentExplainApplication;

    protected String getPagePath() {
        return "/biz/topsun/base/attachmentExplain/";
    }

    @RequiresPermissions("AttachmentExplain:query")
    public String forwardListAttachmentExplain() {
        return forward("attachmentExplainList");
    }

    @RequiresPermissions("AttachmentExplain:query")
    @LogInfo(logType = LogType.BIZ, subType = "", operaionType = OperationType.QUERY, description = "分页查询附件上传说明")
    public String slicedQueryAttachmentExplain() {
        SDO sdo = this.getSDO();
        AttachmentExplainQueryRequest queryRequest = sdo.toQueryRequest(AttachmentExplainQueryRequest.class);
        Map<String, Object> data = attachmentExplainApplication.slicedQueryAttachmentExplain(queryRequest);
        return toResult(data);
    }

    @RequiresPermissions("AttachmentExplain:create")
    @LogInfo(logType = LogType.BIZ, subType = "", operaionType = OperationType.DETALL, description = "跳转到新增附件上传说明")
    public String showInsertAttachmentExplain() {
        this.putAttribute("status", YesOrNo.YES.getId());
        return forward("attachmentExplainDetail");
    }

    @RequiresPermissions("AttachmentExplain:create")
    @LogInfo(logType = LogType.BIZ, subType = "", operaionType = OperationType.ADD, description = "新增保存附件上传说明")
    public String insertAttachmentExplain() {
        SDO sdo = this.getSDO();
        AttachmentExplain attachmentExplain = sdo.toObject(AttachmentExplain.class);
        String id = attachmentExplainApplication.saveAttachmentExplain(attachmentExplain);
        return success(id);
    }

    @RequiresPermissions("AttachmentExplain:update")
    @LogInfo(logType = LogType.BIZ, subType = "", operaionType = OperationType.DETALL, description = "跳转到编辑附件上传说明")
    public String showLoadAttachmentExplain() {
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        AttachmentExplain attachmentExplain = attachmentExplainApplication.loadAttachmentExplain(id);
        return forward("attachmentExplainDetail", attachmentExplain);
    }

    @RequiresPermissions("AttachmentExplain:update")
    @LogInfo(logType = LogType.BIZ, subType = "", operaionType = OperationType.UPDATE, description = "新增修改附件上传说明")
    public String updateAttachmentExplain() {
        SDO sdo = this.getSDO();
        AttachmentExplain attachmentExplain = sdo.toObject(AttachmentExplain.class);
        attachmentExplainApplication.saveAttachmentExplain(attachmentExplain);
        return success();
    }

    @RequiresPermissions("AttachmentExplain:delete")
    @LogInfo(logType = LogType.BIZ, subType = "", operaionType = OperationType.DELETE, description = "删除附件上传说明")
    public String deleteAttachmentExplain() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getStringList("ids");
        attachmentExplainApplication.deleteAttachmentExplain(ids);
        return success();
    }

    @RequiresPermissions("AttachmentExplain:update")
    @LogInfo(logType = LogType.BIZ, subType = "", operaionType = OperationType.DELETE, description = "修改附件上传状态")
    public String updateAttachmentExplainStatus() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getStringList("ids");
        Integer status = sdo.getInteger("status");
        attachmentExplainApplication.updateAttachmentExplainStatus(ids, status);
        return success();
    }

    public String showAttachmentExplain() {
        SDO sdo = this.getSDO();
        String code = sdo.getString("code");
        AttachmentExplain attachmentExplain = attachmentExplainApplication.loadAttachmentExplainByCode(code);
        return forward("attachmentExplain", attachmentExplain);
    }

    public String showAttachmentExplainList() {
        this.putAttribute("bizId", "attachmentExplainId");
        return forward("attachmentExplainList");
    }

    public String showViewAttachmentExplainList() {
        this.putAttribute("bizId", "attachmentExplainId");
        this.putAttribute("isReadOnly", "true");
        return forward("attachmentExplainList");
    }

    public String showAttachmentManagementMethods() {
        this.putAttribute("bizId", "attachmentManagementMethods");
        this.putAttribute("bizCode", "ssrfManagementMethods");
        this.putAttribute("isWrap", true);
        return forward("/biz/topsun/common/attachment.jsp");
    }
}
