var gridManager = null;

$(document).ready(function () {
    initUI();
    loadGrid();
})
function initUI() {
    UICtrl.initDefaultLayout();

}


function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addHandler,
        deleteHandler: deleteHandler
       // exportExcelHandler:exportExcelHandler,
       // exportModelHandler:{id:'exportModelHandler',img:'fa-cloud-download',text:'导出模板',click:exportModelHandler},

    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "单据编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "创建日期", name: "fillinDate", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请状态", name: "statusTextView", width: 60, minWidth: 60, type: "string", align: "left"},
            {display: "创建人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "订单类型", name: "bsart", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "供货工厂", name: "lifnrName", width: 160, minWidth: 60, type: "string", align: "left"},
            {display: "采购组织", name: "ekorgName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "采购组", name: "ekgrpName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "公司代码", name: "burksName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "消息类型", name: "type", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "凭证编号", name: "message", width: 200, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/sapStockTransfers/slicedSapStockTransfersList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}


//删除按钮
function deleteHandler() {
    let result=DataUtil.getUpdateRow(gridManager);
    if(result.status!==0){
        Public.tip("请选择申请状态的数据！")
        return false;
    }

   // var message = "您确认要删除选择的数据?";
  //  UICtrl.confirm(message, function () {
        DataUtil.del({
            action: 'sapStockTransfers/deleteSapStockTransfers.ajax',
            gridManager: gridManager, idFieldName: 'id',
            onSuccess: function () {
                reloadGrid();
            }
        });
   // });

}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'addSapStockTransfers',
        text: "新增公司内跨工厂存货调拨申请单",
        url: web_app.name + '/sapStockTransfers/forwardSapStockTransfersDetail.job'
    });
}


function doView(id) {
    UICtrl.addTabItem({
        tabid: 'viewSapTransfers'+id,
        text: "公司内跨工厂存货调拨申请单",
        url: web_app.name + '/sapStockTransfers/showStockTransfers.job?bizId='+id+"&isReadOnly=true"
    });
}


