var qualityInfoRecordGridManager = null, refreshFlag = false, _roleId = null, qualitySelectedList = [];
$(document).ready(function () {
        initUI();
        initQualityListGrid();

    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function initQualityListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addHandler,
        copyHandler:{
            id: 'copyHandler', text: "复制", img:'fa-clipboard', click: function(){
                copyQualityInfoRecord();
            }
        }
    });
    qualityInfoRecordGridManager = UICtrl.grid('#qualityInfoRecordGrid', {
            columns: [
                {display: "状态", name: "statusTextView", width: "100", align: "center", type: "string"}
                , {display: "id", name: "id", width: "140", align: "center", type: "string", hide: true}
                , {display: "质量信息记录号", name: "zqinfno", width: "300", minWidth: 60, type: "string", align: "center"}
                , {
                    display: "工厂", name: "werksName", width: "200", align: "center", type: "string",
                },
                {
                    display: "供应商", name: "lieferant", width: "200", align: "center", type: "string",
                },
                {
                    display: "物料编码", name: "matnr", width: "200", align: "center", type: "string",
                },
                {
                    display: "物料描述", name: "maktx", width: "300", align: "center", type: "string",
                },
                {
                    display: "物料组", name: "matklName", width: "200", align: "center", type: "string",
                },
                {
                    display: "合格准入验证节点1", name: "zqavfn1", width: "200", align: "center", type: "string",
                },
                {
                    display: "zvfnc1", name: "zvfnc1", width: "100", align: "center", type: "string",
                },
                {
                    display: "合格准入验证节点2", name: "zqavfn2", width: "200", align: "center", type: "string",
                },
                {
                    display: "节点2结论", name: "zvfnc2", width: "100", align: "center", type: "string",
                },
                {
                    display: "合格准入验证节点3", name: "zqavfn3", width: "200", align: "center", type: "string",
                },
                {
                    display: "节点3结论", name: "zvfnc3", width: "100", align: "center", type: "string",
                },
                {
                    display: "合格准入验证节点4", name: "zqavfn4", width: "200", align: "center", type: "string",
                },
                {
                    display: "节点4结论", name: "zvfnc4", width: "100", align: "center", type: "string",
                },
                {
                    display: "打样单号码", name: "zspaufnr", width: "200", align: "center", type: "string",
                },
                {
                    display: "GRSRQ", name: "grsrq", width: "100", align: "center", type: "string",
                },
                {
                    display: "GRS证书号", name: "grscertnr", width: "200", align: "center", type: "string",
                },
                {
                    display: "GRS证书到期日", name: "grscertdatai", width: "150", align: "center", type: "date",
                },
                {
                    display: "FSC认证要求", name: "fscrq", width: "200", align: "center", type: "string",
                },
                {
                    display: "FSC证书号", name: "fsccertnr", width: "200", align: "center", type: "string",
                },
                {
                    display: "FSC证书到期日", name: "fsccertdatai", width: "150", minWidth: 60, type: "date", align: "center"
                },
                {
                    display: "合格准入状态", name: "zqafst", width: "100", minWidth: 60, type: "string", align: "center",
                },
                {
                    display: "合格有效期从", name: "zvdatab", width: "150", minWidth: 60, type: "date", align: "center",
                },
                {
                    display: "合格有效期到", name: "zvdatai", width: "150", minWidth: 60, type: "date", align: "center",
                },
                {
                    display: "备注文本", name: "ztext", width: "120", align: "center", type: "string",
                }
                , {display: "消息类型", name: "typeTextView", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "消息文本", name: "message", width: 300, minWidth: 60, type: "string", align: "center"}
                , {display: "申请人", name: "personMemberName", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "申请部门", name: "deptName", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "申请日期", name: "fillinDate", width: 150, minWidth: 60, type: "date", align: "center"}

            ],
            dataAction: 'server',
            _tableKey: 'sapQualityInfoRecord',
            _local: true,
            url: web_app.name + '/sapQualityInfoRecord/slicedSapQualityInfoRecordList.ajax?',
            //parms: {requireItemId: $("#prepareItemId").val()},
            toolbar: toolbarOptions,
            width: '99.8%',
            height: '100%',
            pageSize: 100,
            heightDiff: -4,
            //sortName: 'lastModifiedDate',
            //sortOrder: 'desc',
            checkbox: true,
            usePager: true,
            rownumbers: true,
            enabledEdit: false,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            enableObjectBag: true,
            onSuccess: function (data) {
                if (data.error) {
                    Public.tip(data.error);
                }
            }
            ,
            onDblClickRow: function (data, rowindex, rowobj) {
                viewHandler(data.sapQualityInfoRecordId);
            },
            onAfterShowData: function (currentData) {

            }
        }
    );
    UICtrl.setSearchAreaToggle(qualityInfoRecordGridManager);
}


/**
 * 查看采购申请详情
 * @param id 采购信息记录申请id
 * @returns {boolean}
 */
function viewHandler(id) {
    if (!id) {
        var row = DataUtil.getSelectedRow(qualityInfoRecordGridManager);
        if (!row) {
            return row;
        }
        id = row.id;
    }
    UICtrl.addTabItem({
        tabid: 'viewQualityInfoRecord' + id,
        text: '查看质量信息记录',
        url: web_app.name + '/sapQualityInfoRecord/showSapQualityInfoRecordDetail.job?isReadOnly=true&bizId=' + id
    });
}

function updateHandler() {
    var row = DataUtil.getSelectedRow(qualityInfoRecordGridManager);
    if (!row) {
        return;
    }
    UICtrl.addTabItem({
        tabid: 'updateQualityInfoRecord' + row.id,
        text: '修改质量信息记录',
        url: web_app.name + '/sapQualityInfoRecord/showSapQualityInfoRecordDetail.job?bizId=' + row.id
    });

}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'addQualityInfoRecord',
        text: '新增质量信息记录',
        url: web_app.name + '/sapQualityInfoRecord/forwardSapQualityInfoRecordDetail.job'
    });
}

function deleteHandler() {
    var rows = DataUtil.getObjectBagData("qualityInfoRecordGrid");
    if (!rows || rows.length < 1) {
        Public.tip('common.warning.nochoose');
        return;
    }
    var ids = [];
    for (var i = 0; i < rows.length; i++) {
        var row = rows[i];
        if (row.status != 0) {
            Public.errorTip('只能删除草稿状态的数据!');
            return;
        }
        ids.push(row.id);
    }
    if (!ids) {
        return;
    }
    Public.ajax(web_app.name + '/sapQualityInfoRecord/deleteByIds.ajax',
        {ids: $.toJSON(ids)},
        function () {
            reloadQualityGrid();
        });
}

function reloadQualityGrid() {
    var params = $("#queryMainForm").formToJSON();
    UICtrl.gridSearch(qualityInfoRecordGridManager, params);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(qualityInfoRecordGridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
}

function copyQualityInfoRecord(){
    var row = DataUtil.getSelectedRow(qualityInfoRecordGridManager);
    if (!row) {
        return;
    }
    UICtrl.addTabItem({
        tabid: 'copyQualityInfoRecord' + row.sapQualityInfoRecordId,
        text: '复制质量信息记录',
        url: web_app.name + '/sapQualityInfoRecord/copyQualityInfoRecord.job?id=' + row.sapQualityInfoRecordId
    });
}

