var itemGridManager = null,fillinDate="";
$(function () {
    initialize();
    //initItemGrid();
    bindEvent();
});

function initialize(){
    fillinDate = $("#fillinDate").val();
    $('#qualityInfoRecordList').fileList();
    UICtrl.layout("#layout", {leftWidth: 3});
}

function bindEvent() {

    //工厂
    $('#werksName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "WERKS"}
        },
        onChange: function (value, data) {
            $('#werks').val(data.WERKS);
            $('#werksName').val(data.NAME1);
        }
    });

    //供应商
    $('#lifnrName').searchbox({
        type: "suppliers", name: "selectSuppliers",
        getParam: function (item) {
        },
        onChange: function (value, data) {
            $('#lieferant').val(data.partner);
            $('#lifnrName').val(data.nameOrg1);
        }
    });

    //物料编码
    $('#matnr').searchbox({
        type: "system", name: "sapMaterialSelect",
        getParam: function (item) {
            if (Public.isBlank($("#werks").val())){
                Public.tip("请先选择工厂");
                return false;
            }
            if (Public.isNotBlank($("#matkl").val()) && Public.isBlank($("#maktx").val())){
                Public.tip("选择了物料组不能再选择物料");
                return false;
            }
            return {
                filterValue: $("#werks").val()
            }
        },
        onChange: function (value, data) {
            $('#matnr').val(data.MATNR);
            $('#maktx').val(data.MAKTX);
            $('#matkl').val(data.MATKL);
            $('#matklName').val(data.WGBEZ);
        }
    });

    //物料组
    $('#matklName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            if (Public.isNotBlank($("#matnr").val())){
                Public.tip("选择了物料不能再选择物料组");
                return false;
            }
            return {fieldName: "MATKL"}
        },
        onChange: function (value, data) {
            $('#matkl').val(data.MATKL);
            $('#matklName').val(data.WGBEZ);
        }
    });

    $('#unitName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "MEINS"}
        },
        onChange: function (value, data) {
            $('#unit').val(data.MSEH3);
            $('#unitName').val(data.MSEHL);
        }
    });
}

function initItemGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function(){
            UICtrl.addGridRow(itemGridManager,{
                zvdatab: $("#fillinDate").val()
                }
            );
        },
        deleteHandler: function (){
            var _grid = UICtrl.getGridManager('#maingrid');
            DataUtil.delSelectedRows({
                action: 'sapQualityInfoRecordItem/deleteSapQualityInfoRecordItem.ajax',
                param: {},
                gridManager: _grid,
                idFieldName: 'id',
                onSuccess: function () {
                    reloadGrid();
                }
            });
        },
    });
        itemGridManager = UICtrl.grid('#maingrid', {
            columns: getGridColumns(),
            dataAction: 'server',
            _tableKey: 'sapQualityInfoRecordItem',
            _local: true,
            url: web_app.name + '/sapQualityInfoRecordItem/querySapQualityInfoRecordItems.ajax',
            parms:{sapQualityInfoRecordId:Public.isNotBlank(getId())?getId():$("#tempId").val()},
            height: '95%',
            heightDiff: -4,
            sortName: 'id',
            sortOrder: 'asc',
            checkbox: true,
            usePager: true,
            rownumbers: true,
            enabledEdit: true,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            //autoApplyNextEditor:false,
            toolbar: toolbarOptions,
            onBeforeEdit: function (editParma) {
                //输入物料号敲回车后，品名描述和无老祖自动带出，而且这两个字段将成为灰色，不允许修改
                if (Public.isNotBlank(editParma.record.matnr) && editParma.column.name=='matklName'){
                    return false;
                }
                //不输入物料号而只输入物料组。这种情况下，物料编码和品名描述字段就是灰色，而物料组可以写操作
                if (Public.isNotBlank(editParma.record.matklName) && Public.isBlank(editParma.record.matnr) && editParma.column.name=='matnr'){
                    return false;
                }
                if ("0" === editParma.record.grsrq && (editParma.column.name=='grscertnr' || editParma.column.name=='grscertdatai')){
                    return false;
                }
                if ("0" === editParma.record.fscrq && (editParma.column.name=='fsccertnr' || editParma.column.name=='fsccertdatai')){
                    return false;
                }

                return true;

            },
            onAfterShowData: function (datas) {
                if (Public.isNotBlank($("#tempId").val())){
                    $.each(datas.Rows,function(i,data){
                        itemGridManager.updateRow(data,{
                            zqinfno:"",
                            zqavfn1:"",
                            zvfnc1:"",
                            zqavfn2:"",
                            zvfnc2:"",
                            zqavfn3:"",
                            zvfnc3:"",
                            zqafst:"",
                        })
                    });
                }
            }
        }
    );
    UICtrl.setSearchAreaToggle(itemGridManager);
}

function getGridColumns() {
    var columns = [];
    columns = [
        {display: "质量信息记录号", name: "zqinfno", width: "300", align: "left", type: "string",

            //editor: {required: false, type: "text"}
        },
        {display: "工厂", name: "werksName", width: "200", align: "left", type: "string",
            editor: {
                required: true, type: "select",
                data: {
                    type: 'system',
                    name: "dictionary",
                    getParam: function (item) {
                        return {fieldName: "WERKS"}
                    },
                    back: {
                        WERKS: "werks",
                        NAME1: "werksName",
                    }
                },
            }
        },
        {display: "供应商", name: "lieferant", width: "200", align: "left", type: "string",
            editor: {required: true, type: "text"}
            // editor: {
            //     required: true, type: "select",
            //     data: {
            //         type: 'system',
            //         name: "dictionary",
            //         getParam: function (item) {
            //             return {fieldName: "LIFNR"}
            //         },
            //         back: {
            //             LIFNR: "lifnr",
            //             NAME1: "lifnrName",
            //         }
            //     },
            // }
        },
        {display: "供应商名称", name: "lifnrName", width: "200", align: "left", type: "string",
            editor: {required: false, type: "text"}
        },
        {display: "物料编码", name: "matnr", width: "200", align: "left", type: "string",
            editor: {
                required: false, type: "select",
                data: {
                    type: 'system',
                    name: "sapMaterialSelect",
                    getParam: function (item) {
                        return {
                            filterValue:item.werks
                        }
                    },
                    back: {
                        MATNR: "matnr",
                        MAKTX: "maktx",
                        MATKL: "matkl",
                        WGBEZ: "matklName"
                    }
                },
            }
        },
        {display: "物料描述", name: "maktx", width: "300", align: "left", type: "string",
            //editor: {required: true, type: "text"}
        },
        {display: "物料组", name: "matklName", width: "200", align: "left", type: "string",
            editor: {
                required: false, type: "select",
                data: {
                    type: 'system',
                    name: "dictionary",
                    getParam: function (item) {
                        return {
                            fieldName: "MATKL"
                        }
                    },
                    back: {
                        MATKL: "matkl",
                        WGBEZ: "matklName",
                    }
                },
            }
        },

        {display: "合格准入验证节点1", name: "zqavfn1", width: "200", align: "left", type: "string",
            //editor: {required: false, type: "text"}
        },
        {display: "节点1结论", name: "zvfnc1", width: "100", align: "left", type: "string",
            //editor: {type: 'text', }
        },
        {display: "合格准入验证节点2", name: "zqavfn2", width: "200", align: "left", type: "string",
            //editor: {required: false, type: "text"}
        },
        {display: "节点2结论", name: "zvfnc2", width: "100", align: "left", type: "string",
            //editor: {required: false, type: "text"}
        },
        {display: "合格准入验证节点3", name: "zqavfn3", width: "200", align: "left", type: "string",
            //editor: {required: false, type: "text"}
        },
        {display: "节点3结论", name: "zvfnc3", width: "100", align: "left", type: "string",
            //editor: {required: false, type: "text"}
        },
        // {display: "合格准入验证节点4", name: "zqavfn4", width: "200", align: "left", type: "string",
        //     editor: {type: 'text' }
        // },
        // {display: "节点4结论", name: "zvfnc4", width: "100", align: "left", type: "string",
        //     editor: {type: 'text'}
        // },
        {display: "打样单号码", name: "zspaufnr", width: "200", align: "left", type: "string",
            editor: {type: "text", required: false,}
        },
        {display: "GRSRQ", name: "grsrqTextView", width: "100", align: "left", type: "string",
            editor: {
                type: 'dictionary',
                data: {name: 'grsrq'},
                textField: 'grsrqTextView',
                valueField: 'grsrq',
                required: true,
                render: function (item) {
                    return item.grsrqTextView;
                }
            },
        },
        {display: "GRS证书号", name: "grscertnr", width: "200", align: "left", type: "string",
            editor: {type: 'text'},
        },
        {display: "GRS证书到期日", name: "grscertdatai", width: "150", align: "left", type: "date",
            editor: {type: 'date'}
        },
        {display: "FSC认证要求", name: "fscrqTextView", width: "200", align: "left", type: "string",
            editor: {
                type: 'dictionary',
                data: {name: 'fscrq'},
                textField: 'fscrqTextView',
                valueField: 'fscrq',
                required: true,
                render: function (item) {
                    return item.fscrqTextView;
                }
            },
        },
        {display: "FSC证书号", name: "fsccertnr", width: "200", align: "left", type: "string",
            editor: {type: "text"}
        },
        {display: "FSC证书到期日", name: "fsccertdatai", width: "150", minWidth: 60, type: "date", align: "center",
            editor: {type: "date"}
        },
        {display: "合格准入状态", name: "zqafst", width: "100", minWidth: 60, type: "string", align: "center",
            editor: {type: "text"}
        },
        {display: "合格有效期从", name: "zvdatab", width: "150", minWidth: 60, type: "date", align: "center",
            editor: {type: 'date',required: true},
        },
        {display: "合格有效期到", name: "zvdatai", width: "150", minWidth: 60, type: "date", align: "center",
            editor: {type: "date",required: true}
        },
        {display: "备注文本", name: "ztext", width: "120", align: "left", type: "string",
            editor: {type: 'text'}
        },
    ]
    return columns;
}

//获取数据保存的参数
function getExtendedData(processAction) {
    //回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
        //不验证
        $('#submitForm').attr('check', false);
    }
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#maingrid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: true
        });
        if (!datas) {
            return false;
        }
        var checked1 = false;
        var checked2 = false;
        var checked3 = false;
        var checked4 = false;
        //if (Public.isNotBlank($("#tempId").val())){
            datas.forEach(data=>{
                // data.id = "";
                // data.sapQualityInfoRecordId=""
                // data.zqinfno=""
                // data.type=""
                // data.message=""
                if ("X" === data.grsrq){
                    if (Public.isBlank(data.grscertnr)){
                        checked1 = true;

                    }
                    if (Public.isBlank(data.grscertdatai)){
                        checked2 = true;

                    }
                }
                if ("X" === data.fscrq){
                    if (Public.isBlank(data.fsccertnr)){
                        checked3 = true;

                    }
                    if (Public.isBlank(data.fsccertdatai)){
                        checked4 = true;

                    }
                }
            })
        if (checked1){
            Public.tip("GRS证书号不能为空")
            return false
        }
        if (checked2){
            Public.tip("GRS证书到期日不能为空")
            return false
        }
        if (checked3){
            Public.tip("FSC证书号不能为空")
            return false
        }
        if (checked4){
            Public.tip("FSC证书到期日不能为空")
            return false
        }
        //}
        extendedData.items = Public.encodeJSONURI(datas);
    }
    return extendedData;
}

function getId() {
    return $('#id').val();
}

function setId(value) {
    $("#id").val(value);
    //var _grid=UICtrl.getGridManager('#maingrid');
    //_grid.options.parms.sapQualityInfoRecordId = value;
    $('#qualityInfoRecordList').fileList({bizId : value});
}

function reloadGrid() {
    itemGridManager.loadData();
}

function getGridData(){
    var _grid = UICtrl.getGridManager('#maingrid');
    var datas = DataUtil.getGridData({
        gridManager: _grid,
        isAllData: true
    });
    return datas;
}

