var purchaseInfoRecordGridManager = null, refreshFlag = false, _roleId = null, purchaseSelectedList = [];
$(document).ready(function () {
        initUI();
        initPurchaseListGrid();
        bindEvent();
    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function bindEvent(){
    $('#werksName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "WERKS"}
        },
        onChange: function (value, data) {
            $('#werks').val(data.WERKS);
            $('#werksName').val(data.NAME1);
        }
    });

    $('#name1').searchbox({
        type: "suppliers", name: "selectSuppliers",
        getParam: function (item) {
            //return {fieldName: "WERKS"}
        },
        onChange: function (value, data) {
            $('#lifnr').val(data.partner);
            $('#name1').val(data.partner);
        }
    });
}

function initPurchaseListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addHandler,
        copyHandler:{
            id: 'copyHandler', text: "复制", img:'fa-clipboard', click: function(){
                copyQualityInfoRecord();
            }
        },
        updateHandler:{
            id: 'updateHandler', text: "修改", img:'fa-edit', click: function(){
                updateHandlerInfoRecord();
            }
        },
        cancelHandler:{
            id: 'cancelHandler', text: "作废", img:'fa-trash-o', click: function(){
                cancelHandlerInfoRecord();
            }
        },
        impExcelDataHandler:{id:'impExcelData',img:'fa-table',text:'导入数据',click:impExcelDataHandler},
        exportExcelHandler:exportExcelHandler,
    });
    purchaseInfoRecordGridManager = UICtrl.grid('#purchaseInfoRecordGrid', {
            columns: [
                {display: "状态", name: "statusTextView", width: "80", align: "left", type: "string"},
                {display: "id", name: "id", width: "140", align: "left", type: "string", hide: true},
                {display: "单据编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "center"},
                {display: "消息类型", name: "typeTextView", width: 100, minWidth: 60, type: "string", align: "center"},
                {display: "消息文本", name: "message", width: 300, minWidth: 60, type: "string", align: "center"},
                {display: "状态标识", name: "flagTextView", width: 100, minWidth: 60, type: "string", align: "center"},
                {display: "采购信息记录编号", name: "infnr", width: 130, minWidth: 60, type: "string", align: "center"},
                {display: "工厂", name: "werksName", width: "200", align: "left", type: "string"},
                {display: "采购组织", name: "ekorgName", width: "200", align: "left", type: "string"},
                {display: "供应商编号", name: "lifnr", width: "100", align: "left", type: "string"},
                {display: "供应商名称1", name: "name1", width: "300", align: "left", type: "string"},
                {display: "供应商物料编码", name: "idnlf", width: "200", align: "left", type: "string"},
                {display: "物料编码", name: "matnr", width: "150", align: "left", type: "string"},
                {display: "物料描述", name: "maktx", width: "300", align: "left", type: "string"},
                {display: "物料组", name: "matklName", width: "150", align: "left", type: "string"},
                {display: "采购信息记录分类", name: "esokzTextView", width: "140", align: "left", type: "string"},
                {display: "采购组", name: "ekgrpName", width: "200", align: "left", type: "string"},
                {display: "净价", name: "netpr", width: "100", align: "left", type: "string"},
                {display: "运输费", name: "freight", width: "100", align: "left", type: "string"},
                {display: "包装费", name: "kbetr6", width: "100", align: "left", type: "string"},
                {display: "货币码", name: "waersTextView", width: "100", align: "left", type: "string",},
                {display: "价格单位", name: "peinh", width: "100", align: "left", type: "string"},
                {display: "订单价格单位(采购)", name: "bprmeName", width: "90", align: "left", type: "string"},
                {display: "标准采购订单数量", name: "norbm", width: "120", align: "left", type: "string"},
                {display: "基本计量单位", name: "meinsName", width: "100", align: "left", type: "string"},
                {display: "订单单位转换分母", name: "umren", width: "100", align: "left", type: "string"},
                {display: "订单单位转换分子", name: "umrez", width: "100", align: "left", type: "string"},
                {display: "销售/购买税代码", name: "mwskzTextView", width: "100", align: "left", type: "string"},
                {display: "开始生效日期", name: "datab", width: "100", align: "left", type: "string"},
                {display: "有效期至日期", name: "datbi", width: "100", align: "left", type: "string"},
                {display: "销售员", name: "verkf", width: "100", align: "left", type: "string"},
                {display: "电话", name: "telf1", width: "100", align: "left", type: "string"},
                {display: "原产地国", name: "urzlaTextView", width: 150, minWidth: 60, type: "string", align: "center"},
                {display: "地区", name: "regioName", width: 150, minWidth: 60, type: "string", align: "center"},
                {display: "删除标志", name: "loekzTextView", width: 150, minWidth: 60, type: "string", align: "center"},
                {display: "排序字段", name: "sortl", width: 150, minWidth: 60, type: "string", align: "center"},
                {display: "最小采购订单数量", name: "minbm", width: "120", align: "left", type: "string"},
                {display: "计划交货时间(天)", name: "aplfz", width: "150", align: "left", type: "string"},

                // {display: "业务标识", name: "zflag", width: 150, minWidth: 60, type: "string", align: "center",
                //     editor: {required: false, type: "text"}
                // },
                {display: '基于收货的发票验证', name: "webre", width: "100", align: "left", type: "string"},
                {display: "价格有效至", name: "prdat", width: "100", align: "left", type: "string",hide:true},
                {display: "等级类型", name:"stfkzTextView", width: "200", align: "left", type: "string"},
                {display: "条件等级计量单位", name: "konms", width: "100", align: "left", type: "string"},
                {display: "等级数量1", name: "kstbm", width: "100", align: "left", type: "string"},
                {display: "等级金额1", name: "kbetr", width: "100", align: "left", type: "string"},
                {display: "等级数量2", name: "kstbm2", width: "100", align: "left", type: "string"},
                {display: "等级金额2", name: "kbetr2", width: "100", align: "left", type: "string"},
                {display: "等级数量3", name: "kstbm3", width: "100", align: "left", type: "string"},
                {display: "等级金额3", name: "kbetr3", width: "100", align: "left", type: "string"},
                {display: "申请人", name: "personMemberName", width: 150, minWidth: 60, type: "string", align: "center"},
                {display: "申请部门", name: "deptName", width: 150, minWidth: 60, type: "string", align: "center"},
                {display: "申请日期", name: "fillinDate", width: 150, minWidth: 60, type: "date", align: "center"}
            ],
            dataAction: 'server',
        _tableKey: 'sapPurchaseInfoRecord',
        _local: true,
            url: web_app.name + '/sapPurchaseInfoRecord/slicedSapPurchaseInfoRecordList.ajax?',
            parms: {},
            toolbar: toolbarOptions,
            width: '99.8%',
            height: '100%',
            pageSize: 20,
            heightDiff: -4,
            sortName: 'fillinDate',
            sortOrder: 'desc',
            checkbox: true,
            usePager: true,
            rownumbers: true,
            enabledEdit: false,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            enableObjectBag: true,
            onSuccess: function (data) {
                if (data.error) {
                    Public.tip(data.error);
                }
            }
            ,
            onDblClickRow: function (data, rowindex, rowobj) {
                viewHandler(data.sapPurchaseInfoRecordId);
            },
            onAfterShowData: function (currentData) {

            }
        }
    );
    UICtrl.setSearchAreaToggle(purchaseInfoRecordGridManager);
}


/**
 * 查看采购申请详情
 * @param id 采购信息记录申请id
 * @returns {boolean}
 */
function viewHandler(id) {
    if (!id) {
        var row = DataUtil.getSelectedRow(purchaseInfoRecordGridManager);
        if (!row) {
            return row;
        }
        id = row.id;
    }
    UICtrl.addTabItem({
        tabid: 'viewPurchaseInfoRecord' + id,
        text: '查看采购信息记录',
        url: web_app.name + '/sapPurchaseInfoRecord/showSapPurchaseInfoRecordDetail.job?isReadOnly=true&bizId=' + id
    });
}

function updateHandler() {
    var row = DataUtil.getSelectedRow(purchaseInfoRecordGridManager);
    if (!row) {
        return;
    }
    UICtrl.addTabItem({
        tabid: 'updatePurchaseInfoRecord' + row.id,
        text: '修改采购信息记录',
        url: web_app.name + '/sapPurchaseInfoRecord/showSapPurchaseInfoRecordDetail.job?bizId=' + row.id
    });

}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'addPurchaseInfoRecord',
        text: '新增采购信息记录',
        url: web_app.name + '/sapPurchaseInfoRecord/forwardSapPurchaseInfoRecordDetail.job'
    });
}

function deleteHandler() {
    var rows = DataUtil.getObjectBagData("purchaseInfoRecordGrid");
    if (!rows || rows.length < 1) {
        Public.tip('common.warning.nochoose');
        return;
    }
    var ids = [];
    for (var i = 0; i < rows.length; i++) {
        var row = rows[i];
        if (row.status != 0) {
            Public.errorTip('只能删除草稿状态的数据!');
            return;
        }
        ids.push(row.id);
    }
    if (!ids) {
        return;
    }
    Public.ajax(web_app.name + '/sapPurchaseInfoRecord/deleteByIds.ajax',
        {ids: $.toJSON(ids)},
        function () {
            reloadPurchaseGrid();
        });
}

function reloadPurchaseGrid() {
    var params = $("#queryMainForm").formToJSON();
    UICtrl.gridSearch(purchaseInfoRecordGridManager, params);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(purchaseInfoRecordGridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
}

function copyQualityInfoRecord(){
    var rows = purchaseInfoRecordGridManager.getSelectedRows();
    if (!rows) {
        return;
    }
    var ids = [];
    rows.forEach(row=>{
        ids.push(row.id)
    })
    UICtrl.addTabItem({
        tabid: 'copyPurchaseInfoRecord',
        text: '新增采购信息记录',
        url: web_app.name + '/sapPurchaseInfoRecord/copyPurchaseRecord.job?ids=' + ids.join(",")
    });
}

function updateHandlerInfoRecord(){
    var rows = purchaseInfoRecordGridManager.getSelectedRows();
    if (rows.length == 0) {
        Public.tip('请选择数据!');
        return;
    }
    var ids = [];
    for (var i = 0; i < rows.length; i++){
        var row=rows[i];
        if (Public.isBlank(row.infnr)) {
            Public.errorTip('只能修改有采购信息记录号的数据!');
            return false;
        }
        ids.push(row.id)
    }

    UICtrl.addTabItem({
        tabid: 'updatePurchaseInfoRecord' + row.id,
        text: '修改采购信息记录',
        url: web_app.name + '/sapPurchaseInfoRecord/showUpdateSapPurchaseInfoRecordDetail.job?ids='+ ids.join(",")
    })
}

function cancelHandlerInfoRecord(){
    var rows = purchaseInfoRecordGridManager.getSelectedRows();
    if (rows.length == 0) {
        Public.tip('请选择数据!');
        return;
    }
    var ids = [];
    for (var i = 0; i < rows.length; i++){
        var row=rows[i];
        if (Public.isBlank(row.infnr)) {
            Public.errorTip('只能作废有采购信息记录号的数据!');
            return false;
        }
        ids.push(row.id)
    }

    UICtrl.addTabItem({
        tabid: 'cancelHandlerInfoRecord' + row.id,
        text: '作废采购信息记录',
        url: web_app.name + '/sapPurchaseInfoRecord/showCancelHandlerInfoRecord.job?ids='+ ids.join(",")
    })
}

//导出Excel
function exportExcelHandler() {
    var date = Public.formatDate(new Date(),`%Y%M%D`);
    UICtrl.gridExport(purchaseInfoRecordGridManager,{fileName:"采购信息记录"+date});
}

function impExcelDataHandler(){
    ExcelImpManager.showImpDialog('导入', 'sapPurchaseInfoRecord', Public.getUUID());
}

