var itemGridManager = null;
$(function () {
    $("#toolBar").toolBar("enable", "forceAbortTask");
    revoke();
    initItemGrid();
    bindEvent();
    var batxt = $("#batxt").val();
    if ("库存转储" == batxt){
        $("#billTitle .subject").html(batxt)
    }
});

function bindEvent() {


}

function revoke(){
    var revokeType = $("#revokeType").val();
    if ("update" == revokeType) {
        $("#billTitle .subject").html("撤审修改采购申请审批")
        $("#revoke").show();
    }else if ("close" == revokeType){
        $("#billTitle .subject").html("撤审关闭采购申请审批")
        $("#revoke").show();
    }else {
        $("#revoke").hide();
    }
}

function initItemGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function(){
            UICtrl.addGridRow(itemGridManager);
        },
        deleteHandler: function (){
            var _grid = UICtrl.getGridManager('#maingrid');
            DataUtil.delSelectedRows({
                action: 'sapPurchaseApprovalItem/deleteSapPurchaseApprovalItem.ajax',
                param: {},
                gridManager: _grid,
                idFieldName: 'id',
                onSuccess: function () {
                    reloadGrid();
                }
            });
        },
    });
        itemGridManager = UICtrl.grid('#maingrid', {
            columns: getGridColumns(),
            dataAction: 'server',
            _tableKey: 'sapPurchaseApprovalItem',
            _local: true,
            url: web_app.name + '/sapPurchaseApprovalItem/querySapPurchaseApprovalItems.ajax',
            parms:{sapPurchaseApprovalId:getId()},
            height: '95%',
            heightDiff: -4,
            sortName: 'id',
            sortOrder: 'asc',
            checkbox: false,
            usePager: true,
            rownumbers: true,
            enabledEdit: false,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            //autoApplyNextEditor:false,
            toolbar: toolbarOptions,
        }
    );
    UICtrl.setSearchAreaToggle(itemGridManager);
}

function getGridColumns() {
    var columns = [];
    columns = [
        {display: "项目编号", name: "bnfpo", width: "80", align: "left", type: "string",
        },
        {display: "项目类别", name: "pstyp", width: "100", align: "left", type: "string"},
        {display: "项目类别描述", name: "ptext", width: "100", align: "left", type: "string"},
        {display: "科目分配类别", name: "knttp", width: "100", align: "left", type: "string",},
        {display: "科目分配类别描述", name: "knttx", width: "100", align: "left", type: "string"},
        {display: "发货工厂", name: "reswk", width: "100", align: "left", type: "string",},
        {display: "收货工厂", name: "werks", width: "100", align: "left", type: "string",},
        {display: "工厂名称", name: "name1", width: "200", align: "left", type: "string"},
        {display: "物料编号", name: "matnr", width: "200", align: "left", type: "string",},
        {display: "物料描述", name: "txz01", width: "300", align: "left", type: "string",},
        {display: "文本", name: "maktxRemZh", width: "300", align: "left", type: "string",},
        {display: "物料组", name: "matkl", width: "100", align: "left", type: "string",},
        {display: "物料组描述", name: "wgbez", width: "100", align: "left", type: "string",},
        {display: "采购申请数量", name: "menge", width: 150, minWidth: 60, type: "string", align: "center",},
        {display: "采购申请计量单位", name: "meins", width: 150, minWidth: 60, type: "string", align: "center",},
        {display: "单位描述", name: "msehl", width: 150, minWidth: 60, type: "string", align: "center",},
        {display: "要求交货日期", name: "lfdat", width: "100", align: "left", type: "string",},
        {display: "库存地点", name: "lgort", width: "100", align: "left", type: "string",},
        {display: "库存地点名称", name: "lgobe", width: "100", align: "left", type: "string"},
        {display: "采购组", name: "ekgrp", width: 150, minWidth: 60, type: "string", align: "center",},
        {display: "采购组描述", name: "eknam", width: 200, minWidth: 60, type: "string", align: "center",},
        {display: "评估价格", name: "preis", width: "100", align: "left", type: "string",},
        {display: "价格单位", name: "meins", width: 100, minWidth: 60, type: "string", align: "center",},
        {display: "币种", name: "waers", width: "60", align: "left", type: "string",},
        {display: "价格基数", name: "peinh", width: "100", align: "left", type: "string",},
        {display: "需求(请求)日期", name: "badat", width: "100", align: "left", type: "string",},
        {display: "创建人", name: "ernam", width: "100", align: "left", type: "string",},
        {display: "申请人", name: "nameText", width: "100", align: "left", type: "string",},
    ]
    return columns;
}

//获取数据保存的参数
function getExtendedData(processAction) {
    //回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
        //不验证
        $('#submitForm').attr('check', false);
    }
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#maingrid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: true
        });
        if (!datas) {
            return false;
        }
        extendedData.sapPurchaseApprovalItems = Public.encodeJSONURI(datas);
    }
    return extendedData;
}

function getId() {
    return $('#id').val();
}

function setId(value) {
    $("#id").val(value);
    var _grid=UICtrl.getGridManager('#maingrid');
    _grid.options.parms.sapPurchaseApprovalId = value;
}

function reloadGrid() {
    itemGridManager.loadData();
}

function getGridData(){
    var _grid = UICtrl.getGridManager('#maingrid');
    var datas = DataUtil.getGridData({
        gridManager: _grid,
        isAllData: true
    });
    return datas;
}


