var gridManager = null, refreshFlag = false;
$(document).ready(function () {
        initUI();
        initGrid();
    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function initGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({

    });

    gridManager = UICtrl.grid('#anlngrid', {
            columns: [
                {
                    display: "工厂", name: "BUKRS", width: "80", align: "left", type: "string",
                },
                {
                    display: "资产编号", name: "ANLN1", width: "100", align: "left", type: "string",
                },
                {
                    display: "资产类型", name: "ANLKL", width: "60", align: "left", type: "string",
                },
                {
                    display: "资产类型描述", name: "TXK20", width: "200", align: "left", type: "string",
                },
                {
                    display: "资产描述", name: "TXT50", width: "300", align: "left", type: "string",
                },
            ],
            dataAction: 'server',
            url: web_app.name + '/sapPurchase/queryAnlanFromSap.ajax?',
            parms: {
                //werks: $("#werks").val(),
                matkl: $("#matkl").val()
            },
            toolbar: toolbarOptions,
            width: '99.8%',
            height: 500,
            pageSize: 20,
            heightDiff: -4,
            sortName: 'num',
            sortOrder: 'asc',
            checkbox: true,
            usePager: false,
            rownumbers: true,
            enabledEdit: true,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            enableObjectBag: true,
            onSelectRow: function (row) {
                var selectValues = $("#selectValues").val();
                if (selectValues == "") {
                    selectValues = row.ANLN1;
                }else {
                    selectValues += "," + row.ANLN1;
                }
                $("#selectValues").val(selectValues);
            },
            onUnSelectRow: function (row) {
                var selectValues = $("#selectValues").val();
                var arr = selectValues.split(",");
                arr = arr.filter(item => item !== row.ANLN1);
                selectValues = arr.join(",");
                $("#selectValues").val(selectValues);
            },
        }
    );
    UICtrl.setSearchAreaToggle(gridManager);
}

function reloadGrid() {
    gridManager.loadData();
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
    reloadGrid();
}

