var purchaseApprovalGridManager = null;
$(document).ready(function () {
        initUI();
        initPurchaseListGrid();
    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function initPurchaseListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
    });
    purchaseApprovalGridManager = UICtrl.grid('#purchaseApprovalGrid', {
            columns: [
                {display: "状态", name: "statusTextView", width: "100", align: "left", type: "string"}
                , {display: "id", name: "id", width: "140", align: "left", type: "string", hide: true}
                , {display: "BPM单据编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "报废申请号", name: "zsanum", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "项目", name: "zsapos", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "物料", name: "matnr", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "物描述料", name: "maktx", width: 300, minWidth: 60, type: "string", align: "center"}
                , {display: "数量", name: "erfmg", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "单位", name: "erfme", width: 150, minWidth: 60, type: "string", align: "center"}
                //, {display: "单位描述", name: "erfmeName", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "工厂", name: "werks", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "工厂描述", name: "werksName", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "存储地点", name: "lgort", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "存储地点描述", name: "lgortName", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "成本中心", name: "kostl", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "成本中心描述", name: "kostlName", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "批次", name: "charg", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "序列号/PL号", name: "sernr", width: 150, minWidth: 60, type: "string", align: "center"}
                , {display: "文本", name: "ztxt", width: 300, minWidth: 60, type: "string", align: "center"}
                , {display: "消息类型", name: "type", width: 100, minWidth: 60, type: "string", align: "center"}
                , {display: "消息文本", name: "message", width: 200, minWidth: 60, type: "string", align: "center"}
                , {display: "创建人", name: "personMemberName", width: 140, minWidth: 60, type: "date", align: "center"}
                , {display: "SAP创建人", name: "zuser1", width: 140, minWidth: 60, type: "date", align: "center"}
                , {display: "创建日期", name: "fillinDate", width: 140, minWidth: 60, type: "date", align: "center"}
                , {display: "SAP创建日期", name: "zdat", width: 140, minWidth: 60, type: "date", align: "center"}
            ],
            dataAction: 'server',
            _tableKey: 'productScrapApply',
            _local: true,
            url: web_app.name + '/productScrapApply/slicedProductScrapApplyList.ajax?',
            //parms: {requireItemId: $("#prepareItemId").val()},
            toolbar: toolbarOptions,
            width: '99.8%',
            height: '100%',
            pageSize: 20,
            heightDiff: -4,
            sortName: 'fillinDate',
            sortOrder: 'desc',
            checkbox: true,
            usePager: true,
            rownumbers: true,
            enabledEdit: false,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            enableObjectBag: true,
            onSuccess: function (data) {
                if (data.error) {
                    Public.tip(data.error);
                }
            }
            ,
            onDblClickRow: function (data, rowindex, rowobj) {
                viewHandler(data.productScrapApplyId);
            },
            onAfterShowData: function (currentData) {

            }
        }
    );
    UICtrl.setSearchAreaToggle(purchaseApprovalGridManager);
}


/**
 * 查看采购申请详情
 * @param id 采购申请id
 * @returns {boolean}
 */
function viewHandler(id) {
    if (!id) {
        var row = DataUtil.getSelectedRow(purchaseApprovalGridManager);
        if (!row) {
            return row;
        }
        id = row.id;
    }
    UICtrl.addTabItem({
        tabid: 'viewProductScrapApply' + id,
        text: '查看物品报废申请与过账平台',
        url: web_app.name + '/productScrapApply/showProductScrapApplyDetail.job?isReadOnly=true&bizId=' + id
    });
}


function reloadPurchaseGrid() {
    var params = $("#queryMainForm").formToJSON();
    UICtrl.gridSearch(purchaseApprovalGridManager, params);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(purchaseApprovalGridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
}

