<%@ page contentType="text/html; charset=utf-8" language="java" %>
<%@ taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <x:base include="layout,dialog,grid,tree,dateTime,combox,attachment,commonTree,comboDialog"/>
    <x:script src='/biz/topsun/sap/processQuotedPrice/processQuotedPriceList.js'/>
</head>
<body>
<div class="container-fluid">
    <div id="layout">
        <div position="center" title="工序报价查询">
            <x:title title="common.button.search" hideTable="queryMainForm" isHide="true"/>
            <form class="hg-form ui-hide" method="post" action="" id="queryMainForm">
                <div class="hg-form-row">
                    <x:inputC name="billCode" required="false" label="申请单号" labelCol="1"/>
                    <x:inputC name="deptName" required="false" label="申请部门" labelCol="1" wrapper="select"/>
                    <x:hidden name="deptId"/>
                    <x:inputC name="personMemberName" required="false" label="申请人" labelCol="1" wrapper="select"/>
                    <x:hidden name="personMemberId"/>
                </div>
                <div class="hg-form-row">
                    <x:inputC name="productCode" required="false" label="产品编码" labelCol="1"/>
                    <x:inputC name="productName" required="false" label="产品名称" labelCol="1" fieldCol="5"/>
                </div>
                <div class="hg-form-row">
                    <x:inputC name="fillinDateBegin" required="false" label="录入日期" labelCol="1" wrapper="date"/>
                    <x:inputC name="fillinDateEnd" required="false" label="-" labelCol="0" wrapper="date"/>
                </div>
                <div class="hg-form-row">
                    <x:checkboxListC name="statusKind" label="单据状态" list="statusKindsList" labelCol="1" fieldCol="3"/>
                </div>
                <x:searchButtons/>
            </form>
            <div class="blank_div clearfix"></div>
            <div id="processQuotedPriceGrid" style="margin: 2px;"></div>
            <div id="itemGrid" style="margin: 2px;"></div>
        </div>
    </div>
</div>
</body>
</html>