var gridManager = null;
var refreshFlag = false;

$(document).ready(function () {
    initializateUI()
    loadProcessQuotedPriceListGrid();
    bindEvent();
})
function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}
function loadProcessQuotedPriceListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function (){
            addHandler()
        }
    });
    gridManager = UICtrl.grid("#processQuotedPriceGrid", {
        columns: [
            {display: "申请单编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "申请状态", name: "statusTextView", width: 60, minWidth: 60, type: "string", align: "left"},
            {display: "申请日期", name: "fillinDate", width: 120, minWidth: 60, type: "datetime", align: "left"},
            {display: "供应商", name: "supplierName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "报价日期", name: "quotedPriceDate", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "支付方式", name: "payMethodTextView", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "报价币别", name: "currencyName", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "备注", name: "remark", width: 300, minWidth: 60, type: "string", align: "left"},
            {display: "申请人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        _tableKey: 'processQuotedPrice',
        _local: true,
        url: web_app.name + '/processQuotedPrice/slicedProcessQuotedPriceList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        detail: { onShowDetail:showUseBill },
        sortName:"fillinDate",
        sortOrder: 'desc',
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: false,
        async: false,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function bindEvent(){
    $("#deptName").orgTree({
        filter: "dpt", excludePos: 0, param: {orgKindId: "ogn,dpt",orgRoot: '14636F3F48934EE7811768692A0AC5E1'},
        back: {
            text: "#deptName",
            value : '#deptName'
        },
    });

    $("#personMemberName").orgTree({
        filter: "psm", excludePos: 0, param: {orgKindId: "ogn,dpt,pos,psm",orgRoot: '14636F3F48934EE7811768692A0AC5E1'},
        back: {
            text: "#personMemberName",
            value : '#personMemberId'
        },
    });

    //产品类别
    $('#productTypeName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "MATKL"}
        },
        onChange: function (value, data) {
            $('#productType').val(data.MATKL);
            $('#productTypeName').val(data.WGBEZ);
        }
    });
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'processQuotedPriceApply',
        text: "工序报价申请",
        url: web_app.name + '/processQuotedPrice/forwardProcessQuotedPriceDetail.job'
    });
}

function doView(processQuotedPriceId) {
    UICtrl.addTabItem({
        tabid: 'processQuotedPrice'+processQuotedPriceId,
        text: "工序报价申请明细",
        url: web_app.name + '/processQuotedPrice/showProcessQuotedPriceDetail.job?isReadOnly=true&bizId='+processQuotedPriceId
    });
}

function showUseBill(row,panel){
    if(!row.id)
        return;
    var gridId = 'test'+row.id;
    gridId=gridId.replace(/[-]/g, '_');

    var grid=$('<div id="'+ gridId +'"></div')
    Public.ajax(web_app.name + "/processQuotedPrice/queryProcessQuotedPriceItems.ajax",
        {processQuotedPriceId:row.id},function(res){
            $(panel).append(grid);
            var planGrid= UICtrl.grid(grid,{
                columns: getItemColumns(),
                dataAction: 'local',
                detail: { onShowDetail:showItemNumber },
                checkbox: false,
                width: '100%',
                height: '10%',
                usePager: false,
                heightDiff: -5,
                data:res
            });
        });
}

function getItemColumns(){
    var columns = [];
    // columns.push({
    //     display: "操作", name: "bindAnln1", width: 150, minWidth: 60, type: "string", align: "left",
    //     render: function (item) {
    //         var html = [];
    //         html.push('<a class="bindAnln1" href="javascript:void(0);"');
    //         html.push(' data-id="', item.id, '"');
    //         html.push(' data-code="', item.productCode, '"');
    //         html.push(' data-process="', item.outProcess, '">');
    //         html.push('<i class="fa fa-location-arrow"></i>&nbsp;');
    //         html.push('报价规则');
    //         html.push('</a>');
    //         return html.join('');
    //     }
    // },)
    columns.push({display: "项次", name: "itemNo", width: 60, minWidth: 60, type: "string", align: "left"});
    columns.push({display: "启用/禁用", name: "status", width: 80, minWidth: 60, type: "string", align: "left",
        render: function (item) {
            return UICtrl.getStatusInfo(item.status);
        }
    });
    columns.push({
        display: "产品编码", name: "productCode", width: 160, minWidth: 60, type: "string", align: "left",
    },);
    columns.push({
        display: "产品名称", name: "productName", width: 300, minWidth: 60, type: "string", align: "left",
    },);
    columns.push({display: "外发工序编码", name: "outProcess", width: 100, minWidth: 60, type: "string", align: "left",
    },);
    columns.push({display: "外发工序名称", name: "outProcessName", width: 150, minWidth: 60, type: "string", align: "left",
    },);
    columns.push({
        display: "机台", name: "machineTool", width: 100, minWidth: 60, type: "string", align: "left",
    });
    columns.push({
        display: "印刷色数", name: "printColor", width: 200, minWidth: 60, type: "string", align: "left",
    });
    columns.push({
        display: "库存名称", name: "storeName", width: 140, minWidth: 60, type: "string", align: "left",
    },);
    columns.push({
        display: "备注", name: "remark", width: 200, minWidth: 60, type: "string", align: "left",
    },);
    columns.push({
        display: "禁用人", name: "disablePersonName", width: 100, minWidth: 60, type: "string", align: "left",
    },);
    columns.push({
        display: "禁用时间", name: "disableDate", width: 100, minWidth: 60, type: "string", align: "left",
    },);
    columns.push({
        display: "禁用原因", name: "disableReason", width: 200, minWidth: 60, type: "string", align: "left",
    },);
    return columns;
}

function showItemNumber(row,panel){
    if(!row.id)
        return;
    var gridId = 'test'+row.id;
    gridId=gridId.replace(/[-]/g, '_');

    var grid=$('<div id="'+ gridId +'"></div')
    Public.ajax(web_app.name + "/processQuotedPrice/queryProcessQuotedPriceItemNumbers.ajax",
        {processQuotedPriceItemId:row.id},function(res){
            $(panel).append(grid);
            var planGrid= UICtrl.grid(grid,{
                columns: [
                    {display: "数量起", name: "numberFrom", width: 100, minWidth: 60, type: "String", align: "left"},
                    {display: "数量止", name: "numberTo", width: 100, minWidth: 60, type: "String", align: "left"},
                    {display: "数量区间", name: "numberSection", width: 200, minWidth: 60, type: "String", align: "left"},
                    {display: "备注", name: "remark", width: 200, minWidth: 60, type: "String", align: "left"},
                    {display: "价格单位", name: "priceUnit", width: 100, minWidth: 60, type: "String", align: "left"},
                    {display: "含税单价", name: "unitPrice", width: 100, minWidth: 60, type: "String", align: "left"},
                    {display: " 不含税单价", name: "excludeTaxPrice", width: 100, minWidth: 60, type: "String", align: "left"},
                    {display: "运输费", name: "freight", width: 100, minWidth: 60, type: "String", align: "left",},
                    {display: "包装费", name: "packMoney", width: 100, minWidth: 60, type: "String", align: "left",},
                    {display: "最低消费", name: "minimum", width: 100, minWidth: 60, type: "String", align: "left"},
                    {display: "loss数(%)", name: "lossNumber", width: 100, minWidth: 60, type: "String", align: "left"},
                ],
                dataAction: 'local',
                checkbox: false,
                width: '100%',
                height: '10%',
                usePager: false,
                heightDiff: -5,
                data:res
            });
        });
}