var gridManager = null;

$(document).ready(function () {
    initUI();
    loadGrid();
    bindEvent();
})
function initUI() {
    UICtrl.initDefaultLayout();
}

function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addHandler,
        printHandler: {
            id: 'print', text: '打印', img:'fa-clipboard', click: function(){
                printHandler();
            }
        },
        exportExcelHandler: exportExcelHandler,
        backHandler: {
            id: 'backHandler', text: '退料', img:'fa-edit', click: function(){
                backHandler();
            }
        },
    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "单据编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "领料单号", name: "message", width: 100, minWidth: 60, type: "string", align: "left"},
            //{display: "是否冲销", name: "isChargeOffTextView", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "工厂", name: "werksName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "成本中心", name: "kostlName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "内部订单编号", name: "aufnr", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "内部订单描述", name: "aufnrName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "序号", name: "rspos", width: 70, minWidth: 60, type: "string", align: "left",},
            {display: "物料组编码", name: "matkl", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "物料组描述", name: "wgbez", width: 160, minWidth: 60, type: "string", align: "left"},
            {display: "物料", name: "matnr", width: 160, minWidth: 60, type: "string", align: "left"},
            {display: "SAP物料名称", name: "maktx", width: 300, minWidth: 60, type: "string", align: "left",},
            {display: "物料要求描述", name: "matxt", width: 300, minWidth: 60, type: "string", align: "left",},
            {display: "库存地点", name: "lgobe", width: 200, minWidth: 60, type: "string", align: "left",},
            {display: "数量", name: "erfmg", width: 100, minWidth: 60, type: "string", align: "left",},
            {display: "申请退料数量", name: "backNum", width: 100, minWidth: 60, type: "string", align: "left",},
            {display: "实际退料数量", name: "zerfmg", width: 100, minWidth: 60, type: "string", align: "left",},
            {display: "申请退料原因", name: "backReason", width: 150, minWidth: 60, type: "string", align: "left",},
            {display: "申请退料时间", name: "backDate", width: 150, minWidth: 60, type: "string", align: "left",},
            {display: "退料凭证", name: "chargeOffMessage", width: 150, minWidth: 60, type: "string", align: "left",},
            {display: "是否完结", name: "checkedBox", width: 100, minWidth: 60, type: "string", align: "left",},
            {display: "计量单位", name: "msehl", width: 90, minWidth: 60, type: "string", align: "left",},
            {display: "领料方", name: "wempf", width: 200, minWidth: 60, type: "string", align: "left",},
            {display: "备注用途", name: "usedTextView", width: 200, minWidth: 60, type: "string", align: "left",},
            {display: "审批状态", name: "statusTextView", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "消息类型", name: "typeTextView", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "创建日期", name: "fillinDate", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/nonProducePick/slicedNonProducePickList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        sortName: 'fillinDate',
        sortOrder: 'desc',
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'epSaleOrder',
        text: "创建领料申请",
        url: web_app.name + '/nonProducePick/forwardNonProducePickDetail.job'
    });
}

function doView(id) {
    UICtrl.addTabItem({
        tabid: 'epSaleOrder'+id,
        text: "查看领料申请",
        url: web_app.name + '/nonProducePick/showNonProducePickDetail.job?bizId='+id+"&isReadOnly=true"
    });
}

function printHandler(){
    var row = DataUtil.getUpdateRow(gridManager);
    if (!row) {
        return;
    }
    if (row.status != 3){
        Public.tip("请审批完成再打印!");
        return;
    }
    var url='/nonProducePick/print.load';
    Public.openPostWindow(web_app.name+url,{id :row.id});
}

function backHandler(){
    var row = DataUtil.getUpdateRow(gridManager);
    if (!row) {
        return;
    }
    if (Public.isBlank(row.message)){
        Public.tip("请领料完成再退料!");
        return;
    }
    UICtrl.showAjaxDialog({
        url: web_app.name + '/nonProducePickItem/showBack.load',
        param:{id:row.itemId},
        title: "退料",
        width: 400,
        ok: doSaveBackInfo
    });
}

function doSaveBackInfo(div){
    var _self=this;
    $('#saveBackInfoForm',div).ajaxSubmit({url: web_app.name + '/nonProducePickItem/saveNonProducePickItem.ajax',
        success : function(id) {
            reloadGrid();
            _self.close();
        }
    });
}

//导出Excel
function exportExcelHandler() {
    var date = Public.formatDate(new Date(),`%Y%M%D%H%I%S`);
    UICtrl.gridExport(gridManager,{fileName:"领料申请"+date});
}

function bindEvent(){
    $("#deptName").orgTree({
        filter: "dpt", excludePos: 0, param: {orgKindId: "ogn,dpt"},
        back: {
            text: "#deptName",
            value: ''
        },
    });

    $("#personMemberName").orgTree({
        filter: "psm", excludePos: 0, param: {orgKindId: "ogn,dpt,pos,psm"},
        back: {
            text: "#personMemberName",
            value: ''
        },
    });
}
