var gridManager = null;
$(document).ready(function () {
        initUI();
        initGrid();
    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function initGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
    });
    gridManager = UICtrl.grid('#grid', {
            columns: [
                {display: "状态", name: "statusTextView", width: "100", align: "left", type: "string"},
                {display: "id", name: "id", width: "140", align: "left", type: "string", hide: true},
                {display: "BPM单据号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "center"},
                {display: "仓库号", name: "lgnum", width: 100, minWidth: 60, type: "string", align: "center"},
                {display: "仓库描述", name: "lnumt", width: 200, minWidth: 60, type: "string", align: "center"},
                {display: "盘点记录号", name: "ivnum", width: "100", align: "left", type: "string"},
                {display: "重新盘点版本", name: "nvers", width: "100", align: "left", type: "string"},
                {display: "项目号", name: "ivpos", width: "100", align: "left", type: "string"},
                {display: "仓位", name: "lgpla", width: "100", align: "left", type: "string"},
                {display: "物料", name: "matnr", width: "100", align: "left", type: "string",
                    //去掉前导0
                    render: function (item) {
                        return item.matnr.replace(/^0+/, "");
                    }
                },
                {display: "物料描述", name: "maktx", width: "300", align: "left", type: "string"},
                {display: "批次", name: "charg", width: "100", align: "left", type: "string",},
                {display: "工厂", name: "werks", width: "100", align: "left", type: "string",},
                {display: "工厂名称", name: "name1", width: "200", align: "left", type: "string"},
                {display: "存储地点", name: "lgort", width: "100", align: "left", type: "string",},
                {display: "存储地点名称", name: "lgobe", width: "100", align: "left", type: "string",},
                {display: "库存类别", name: "bestq", width: "100", align: "left", type: "string",},
                {display: "特殊库存标识", name: "sobkz", width: "100", align: "left", type: "string",},
                {display: "特殊库存编号", name: "sonum", width: 100, minWidth: 60, type: "string", align: "center",},
                {display: "盘点数量", name: "menga", width: 100, minWidth: 60, type: "string", align: "center",},
                {display: "盘点数量单位", name: "msehl", width: 100, minWidth: 60, type: "string", align: "center",},
                {display: "账面数量", name: "gesme", width: "100", align: "left", type: "string",},
                {display: "差异（%）", name: "abwei", width: "100", align: "left", type: "string",},
                {display: "价值差额", name: "dwert", width: "100", align: "left", type: "string"},
                {display: "货币", name: "ktext", width: 100, minWidth: 60, type: "string", align: "center",},
                {display: "盘点完成日期", name: "idatu", width: 100, minWidth: 60, type: "string", align: "center",},
                {display: "创建人", name: "personMemberName", width: "100", align: "left", type: "string",},
                {display: "消息类型", name: "type", width: 100, minWidth: 60, type: "string", align: "center"},
                {display: "消息文本", name: "message", width: 200, minWidth: 60, type: "string", align: "center"},
                {display: "创建日期", name: "fillinDate", width: 140, minWidth: 60, type: "date", align: "center"},
                {display: "消息类型", name: "type", width: "100", minWidth: 60, type: "string", align: "center",},
                {display: "消息文本", name: "message", width: "100", minWidth: 60, type: "string", align: "center",}
            ],
            dataAction: 'server',
            url: web_app.name + '/inventoryRecord/slicedInventoryRecordWmList.ajax?',
            toolbar: toolbarOptions,
            width: '99.8%',
            height: '100%',
            pageSize: 20,
            heightDiff: -4,
            sortName: 'fillinDate',
            sortOrder: 'desc',
            checkbox: true,
            usePager: true,
            rownumbers: true,
            enabledEdit: false,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            enableObjectBag: true,
            onDblClickRow: function (data, rowindex, rowobj) {
                viewHandler(data.id);
            },
        }
    );
    UICtrl.setSearchAreaToggle(gridManager);
}


/**
 * 查看详情
 * @param id 采购申请id
 * @returns {boolean}
 */
function viewHandler(id) {
    if (!id) {
        var row = DataUtil.getSelectedRow(gridManager);
        if (!row) {
            return row;
        }
        id = row.id;
    }
    UICtrl.addTabItem({
        tabid: 'viewInventoryRecord' + id,
        text: '查看库存盘点',
        url: web_app.name + '/inventoryRecord/showInventoryRecordDetail.job?isReadOnly=true&bizId=' + id
    });
}



function reloadGrid() {
    var params = $("#queryMainForm").formToJSON();
    UICtrl.gridSearch(gridManager, params);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
}

