var gridManager = null;

$(document).ready(function () {
    initUI();
    loadGrid();
})
function initUI() {
    UICtrl.initDefaultLayout();

}


function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addHandler
       // exportExcelHandler:exportExcelHandler,
       // exportModelHandler:{id:'exportModelHandler',img:'fa-cloud-download',text:'导出模板',click:exportModelHandler},

    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "单据编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "创建日期", name: "fillinDate", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请状态", name: "statusTextView", width: 60, minWidth: 60, type: "string", align: "left"},
            {display: "申请人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "联系电话", name: "tel", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "原因", name: "reason", width: 300, minWidth: 60, type: "string", align: "left"},
            {display: "资产编号", name: "anln1", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "公司代码", name: "bukrs", width: 120, minWidth: 60, type: "string", align: "left"},
          //  {display: "成本中心", name: "kostl", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "凭证日期", name: "bldat", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "过账日期", name: "budat", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "资产起息日", name: "bzdat", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "报废金额", name: "anbtr", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "百分比", name: "prozs", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "购置业务年度", name: "xa", width: 120, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/sapFixedRetirement/slicedSapFixedRetirementList.ajax',
        pageSize: 20,
        usePager: true,
        sortName: 'fillinDate',
        sortOrder: 'desc',
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.sapRetirementId);
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}


//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'sapFixedRetirement/deleteSapFixedRetirement.ajax',
        gridManager: gridManager, idFieldName: 'id',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'addSapFixedRetirement',
        text: "固定资产报废",
        url: web_app.name + '/sapFixedRetirement/forwardSapFixedRetirementDetail.job'
    });
}

function doView(id) {
    UICtrl.addTabItem({
        tabid: 'viewSapFixedRetirement'+id,
        text: "固定资产报废",
        url: web_app.name + '/sapFixedRetirement/showFixedRetirement.job?bizId='+id+"&isReadOnly=true"
    });
}


//从EXCEL导入数据
function impExcelDataHandler(){
    ExcelImpManager.showImpDialog('导入', 'sapFixedRetirementData', Public.getUUID(), saveUpLoadGrid);
}

function saveUpLoadGrid() {
    var batchNumber=$('#batchNumber').val();
    Public.ajax(web_app.name + '/sapFixedRetirement/importExcelData.ajax'
        , {batchNumber: batchNumber}, function (data) {
            reloadGrid();
    });
}