var gridManager = null;

$(document).ready(function () {
    initialize();
    loadGrid();
    bindEvent();
});
function initialize(){
    var mainFileTable = $('#sapAssessMoveList').fileList();
    mainFileTable.find('table').css({
        borderTopWidth : 0
    });
    $('#sapAssessMoveList').fileList({
        bizId : $("#id").val()
    });
    UICtrl.layout("#layout", {leftWidth: 3});
}

function bindEvent(){

}

function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            UICtrl.addGridRow(gridManager);
        },
        deleteHandler: function () {
            var _grid = UICtrl.getGridManager('#maingrid');
            DataUtil.delSelectedRows({
                action: 'sapFixedAssetsMoveItem/deleteSapFixedAssetsMoveItems.ajax',
                param: {},
                gridManager: _grid,
                idFieldName: 'id',
                onSuccess: function () {
                    reloadGrid();
                }
            });
        },
        impExcelDataHandler:{id:'impExcelData',img:'fa-table',text:'导入数据',click:impExcelDataHandler},
    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {
                display: "公司代码", name: "bukrs", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {fieldName: "BUKRS"}
                        },
                        back: {
                            BUKRS: "bukrs",
                        }
                    },
                }
            },
            {
                display: "主资产号", name: "anln1", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {
                                fieldName: "ANLN1",
                                filterValue: item.bukrs
                            }
                        },
                        back: {
                            ANLN1: "anln1",
                            KOSTL: "fromKostl",
                        }
                    },
                }
            },
            {
                display: "申请日期", name: "adatu", width: 140, minWidth: 60, type: "date", align: "left",
                editor: {
                    type: "date",required: true
                }
            },
            {
                display: "原成本中心", name: "fromKostl", width: 140, minWidth: 60, type: "date", align: "left",
            },
            {
                display: "成本中心", name: "kostl", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {fieldName: "KOSTL"}
                        },
                        back: {
                            KOSTL: "kostl"
                        }
                    },
                }
            },
        ],
        dataAction: "server",
        url: web_app.name + '/sapFixedAssetsMoveItem/querySapFixedAssetsMoveItems.ajax',
        pageSize: 100,
        usePager: true,
        parms:{sapFixedAssetsMoveId:getId()},
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "100%",
        height: "80%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

/**
 * 流程引擎回调设置打样的id
 * @param value 打样申请的id
 */
function setId(id) {
    $("#id").val(id);

    var _grid=UICtrl.getGridManager('#maingrid');
    _grid.options.parms.sapFixedAssetsMoveId = id;
    $('#sapAssessMoveList').fileList({
        bizId : id
    });
}

/**
 * 流程引擎获取打样申请id的回掉方法。
 * @return 打样申请的id
 */
function getId() {
    return $("#id").val() || "";
}

function reloadGrid() {
    gridManager.loadData();
}

//从EXCEL导入数据
function impExcelDataHandler(){
    ExcelImpManager.showImpDialog('导入', 'sapFixedAssessMoveData', Public.getUUID(), saveUpLoadGrid);
}

function saveUpLoadGrid() {
    var batchNumber=$('#batchNumber').val();
    Public.ajax(web_app.name + '/sapFixedAssetsMove/importExcelData.ajax'
        , {batchNumber: batchNumber}, function (data) {
            for (var row=0;row<data.length;row++) {
                //debugger
                UICtrl.addGridRow(gridManager,{
                    anln1:data[row].anln1,
                    bukrs:data[row].bukrs,
                    kostl:data[row].kostl,
                    adatu:data[row].adatu,
                });


            }
            //reloadGrid();
        });
}


function getExtendedData(processAction) {
//回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
//不验证
        $('#submitForm').attr('check', false);
    }
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#maingrid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: true
        });
        if (!datas) {
            return false;
        }
        extendedData.items = Public.encodeJSONURI(datas);
    }
    return extendedData;
}
