var gridManager = null;

$(document).ready(function () {
    initialize();
    loadGrid();
    bindEvent();
});
function initialize(){
    var mainFileTable = $('#sapAssessInfoList').fileList();
    mainFileTable.find('table').css({
        borderTopWidth : 0
    });
    $('#sapAssessInfoList').fileList({
        bizId : $("#attbizId").val()
    });
    UICtrl.layout("#layout", {leftWidth: 3});
}

function bindEvent(){

}

function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            UICtrl.addGridRow(gridManager);
        },
        deleteHandler: function () {
            var _grid = UICtrl.getGridManager('#maingrid');
            DataUtil.delSelectedRows({
                action: 'sapFixedAssessItem/deleteSapFixedAssessItems.ajax',
                param: {},
                gridManager: _grid,
                idFieldName: 'id',
                onSuccess: function () {
                    reloadGrid();
                }
            });
        },
        impExcelDataHandler:{id:'impExcelData',img:'fa-table',text:'导入数据',click:impExcelDataHandler},

    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {
                display: "公司代码", name: "bukrs", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {fieldName: "BUKRS"}
                        },
                        back: {
                            BUKRS: "bukrs",
                        }
                    },
                }
            },
            {
                display: "主资产号", name: "anln1", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {
                                fieldName: "ANLN1",
                                filterValue: item.bukrs
                            }
                        },
                        back: {
                            ANLN1: "anln1"
                        }
                    },
                }
            },

            {
                display: "凭证日期", name: "bldat", width: 120, minWidth: 60, type: "date", align: "left",
                editor: {required: true, type: "date"}
            },
            {
                display: "过账日期", name: "budat", width: 120, minWidth: 60, type: "date", align: "left",
                editor: {required: true, type: "date"}
            },
            {
                display: "资产起息日", name: "bzdat", width: 120, minWidth: 60, type: "date", align: "left",
                editor: {required: true, type: "date"},
                render : function (record) {
                    return record.bzdat = record.budat;
                }
            },
            {
                display: "文本", name: "sgtxt", width: 260, minWidth: 60, type: "string", align: "left",
                editor: {required: false, type: "text"}
            },
            {
                display: "接收方", name: "empge", width: 180, minWidth: 60, type: "string", align: "left",
                editor: {required: true, type: "text"}
            },
            {
                display: "百分比(%)", name: "prozs", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {required: false, mask: 'nnn',type: "text"}
            },
            {
                display: "金额", name: "betrr", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {required: false, mask: 'nnnnnnnn.nn',type:"text"}
            }
        ],
        dataAction: "server",
        url: web_app.name + '/sapFixedAssessItem/querySapFixedAssessItems.ajax',
        pageSize: 100,
        usePager: true,
        parms:{sapFixedAssessId:getId()},
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "100%",
        height: "80%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onBeforeEdit: function (editParm) {
            var c = editParm.column, data = editParm.record;
            // if (c.name == 'anbtr') {//
            //elementGridManager.reRender({ rowdata: data });
            if (Public.isNotBlank(data.betrr) && c.name == 'prozs') {
                return false;
            }
            if (Public.isNotBlank(data.prozs) && c.name == 'betrr') {
                return false;
            }
            // }
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

/**
 * 流程引擎回调设置打样的id
 * @param value 打样申请的id
 */
function setId(id) {
    $("#id").val(id);

    var _grid=UICtrl.getGridManager('#maingrid');
    _grid.options.parms.sapRetirementId = id;
    $('#sapAssessList').fileList({
        bizId : id
    });
}

/**
 * 流程引擎获取打样申请id的回掉方法。
 * @return 打样申请的id
 */
function getId() {
    return $("#id").val() || "";
}

function reloadGrid() {
    gridManager.loadData();
}

//从EXCEL导入数据
function impExcelDataHandler(){
    ExcelImpManager.showImpDialog('导入', 'sapFixedAssessData', Public.getUUID(), saveUpLoadGrid);
}

function saveUpLoadGrid() {
    var batchNumber=$('#batchNumber').val();
    Public.ajax(web_app.name + '/sapFixedAssess/importExcelData.ajax'
        , {batchNumber: batchNumber}, function (data) {
            for (var row=0;row<data.length;row++) {
                //debugger
                UICtrl.addGridRow(gridManager,{anln1:data[row].anln1,bukrs:data[row].bukrs
                ,bldat:data[row].bldat,budat:data[row].budat,bzdat:data[row].budat
                ,sgtxt:data[row].sgtxt,empge:data[row].empge,prozs:data[row].prozs,betrr:data[row].betrr
                });


            }
            //reloadGrid();
        });
}

function getExtendedData(processAction) {
//回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
//不验证
        $('#submitForm').attr('check', false);
    }
    var extendedData = {};
    var checked = false;
    var _grid = UICtrl.getGridManager('#maingrid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: true
        });

        if (!datas) {
            return false;
        }
        $.each(datas, function (i , o) {
            if (Public.isBlank(o.betrr) && Public.isBlank(o.prozs)){
                checked = true;
            }
        })
        if (checked){
            Public.tip("报废金额和百分比(%)不能同时为空");
            return false
        }
        extendedData.items = Public.encodeJSONURI(datas);
    }
    return extendedData;
}
