<%@ page language="java" contentType="text/html; charset=utf-8" %>
<%@taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <script type="text/javascript">
      var applyType ="${applyType}";
    </script>
    <x:base include="layout,dialog,grid,tree,combox,commonTree,date,attachment"/>
    <x:script src='/biz/topsun/sap/finaCustomer/finaCustomerDetail.js'/>
</head>
<body>
<c:if test="${applyType==0}">
  <x:billTitle title="财务客户主数据维护申请表" needStatus="false" needPerson="true"/>
</c:if>
<c:if test="${applyType==1}">
    <x:billTitle title="财务客户主数据修改申请表" needStatus="false" needPerson="true"/>
</c:if>
<c:if test="${applyType==-1}">
    <x:billTitle title="财务客户主数据删除申请表" needStatus="false" needPerson="true"/>
</c:if>
<form class="hg-form" method="post" action="" id="submitForm">
        <x:hidden name="id"/>
        <x:hidden name="sId"/>
        <x:hidden name="applyType"/>
        <%--<x:hidden name="billCode"/>--%>
        <%--<x:hidden name="fillinDate" type="datetime"/>--%>
        <x:hidden name="fullId"/>
        <x:hidden name="organId"/>
        <x:hidden name="organName"/>
        <x:hidden name="deptId"/>
        <%--<x:hidden name="deptName"/>--%>
        <x:hidden name="positionId"/>
        <x:hidden name="positionName"/>
        <x:hidden name="personMemberId"/>
        <x:hidden name="statusId"/>
        <%--<x:hidden name="personMemberName"/>--%>
    <x:title title="申请人填写区域" name="group"/>
    <div class="hg-form-cols">
        <div class="hg-form-row">
            <x:inputC name="billCode" label="申请单编号" labelCol="1" readonly="true" fieldCol="2"/>
            <x:inputC name="personMemberName" label="申请人" readonly="true" labelCol="1" fieldCol="2"/>
            <x:inputC name="deptName" label="申请部门" readonly="true" labelCol="1" fieldCol="2"/>
            <x:inputC name="fillinDate" label="申请日期" readonly="true" wrapper="dateTime" labelCol="1" fieldCol="2"/>
        </div>
    </div>
    <x:title title="财务客户主基本数据" name="group"/>
    <div class="hg-form-cols">
        <div class="hg-form-row">
            <x:inputC name="buPartner" label="客户编号" labelCol="1" fieldCol="2" readonly="true"/>
            <x:inputC name="partnerRole" label="业务伙伴角色" labelCol="1" fieldCol="2" required="false" readonly="true"/>
            <x:inputC name="creationGroup" label="业务伙伴分组" labelCol="1" fieldCol="2" readonly="true"/>
            <x:selectC name="titleMedi" label="称谓代码" labelCol="1" fieldCol="2" dictionary="title"/>
           </div>
        <div class="hg-form-row">
            <x:inputC name="nameOrg1" label="财务客户名称1" labelCol="1" fieldCol="2" required="true"/>
            <x:inputC name="buSort1Txt" label="搜索词1" labelCol="1" fieldCol="2" required="true"/>
            <x:selectC name="langu" label="语言" labelCol="1" fieldCol="2" required="true" dictionary="langu"/>
        </div>
        <div class="hg-form-row">
            <x:inputC name="countryName" label="国家" labelCol="1" fieldCol="2" required="true" wrapper="select"/>
            <x:hidden name="country"/>
            <x:inputC name="regionName" label="地区" labelCol="1" fieldCol="2" required="false" wrapper="select"/>
            <x:hidden name="region"/>
            <x:inputC name="street" label="街道" labelCol="1" fieldCol="2" maxLength="35"/>
            <x:inputC name="postCode1" label="城市邮政编码" labelCol="1" fieldCol="2" required="false" maxLength="6"/>
        </div>
        <div class="hg-form-row">
            <x:inputC name="smtpAddr" label="电子邮件地址" labelCol="1" fieldCol="2" maxLength="30"/>
            <x:inputC name="telNumber" label="电话" labelCol="1" fieldCol="2"/>
            <x:inputC name="mobNumber" label="移动电话" labelCol="1" fieldCol="2"/>
            <x:inputC name="faxNumber" label="传真" labelCol="1" fieldCol="2" maxLength="30"/>
        </div>
        <div class="hg-form-row">
            <%--<x:inputC name="lifnr" label="供应商" labelCol="1" fieldCol="2" maxLength="30"/>--%>
            <x:inputC name="stenr" label="税号" labelCol="1" fieldCol="2" maxLength="30"/>
            <x:hidden name="taxType"/>
            <x:inputC name="taxTypeName" label="税号类型" labelCol="1" fieldCol="2" maxLength="30" wrapper="select"/>
            <x:selectC name="sperr" label="中心记帐冻结" labelCol="1" fieldCol="2" dictionary="sperr"/>
        </div>
        <div class="hg-form-row">
            <x:textareaC name="zbz01" label="备注" labelCol="1" fieldCol="11" rows="3"/>
        </div>
    </div>
    <div style="padding-top: 15px;">
        <x:fileList bizCode="supplier" bizId="attbizId" id="supplierList" title="营业执照/开票资料" />
    </div>
    <div class="blank_div clearfix"></div>
    <x:title title="财务客户公司信息" name="group"/>
    <div id="sapFinaCustomerPayGrid" style="margin: 2px;"></div>
    <div class="blank_div clearfix"></div>
    <x:title title="财务客户银行信息" name="group"/>
    <div id="sapFinaCustomerBankGrid" style="margin: 2px;"></div>
</form>
</body>
</html>
