var gridManager = null, refreshFlag = false
$(document).ready(function () {
        initUI();
        initGrid();
    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function initGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addHandler,
        updateHandler:function (){
            updateHandler();
        },
        deleteHandler: deleteHandler,
        impExcelDataHandler:{id:'impExcelData',img:'fa-table',text:'导入数据',click:impExcelDataHandler},

    });
    gridManager = UICtrl.grid('#maingrid', {
            columns: [
                {display: "序号（一级分类编码）", name: "reasonType", width: "200", align: "center", type: "int"}
                , {display: "标准名称大类（一级分类）", name: "reasonTypeName", width: "200", minWidth: 60, type: "string", align: "center"}
                , {display: "问题类型代码（二级分类 ）", name: "reasonTypeDetail", width: "200", minWidth: 60, type: "string", align: "center"}
                , {display: "问题类型（二级分类 ）", name: "reasonTypeDetailName", width: "500", minWidth: 60, type: "string", align: "center"}
                 ],
            dataAction: 'server',
            url: web_app.name + '/exceptionReasonTypeDetail/slicedExceptionReasonTypeDetailList.ajax?',
            toolbar: toolbarOptions,
            width: '99.8%',
            height: '100%',
            pageSize: 100,
            heightDiff: -4,
            sortName: 'reasonType',
            sortOrder: 'asc',
            checkbox: true,
            usePager: true,
            rownumbers: true,
            enabledEdit: false,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            enableObjectBag: true,
            allowAdjustColWidth: true,
            onDblClickRow: function (data, rowindex, rowobj) {
                updateHandler(data.id);
            },
        }
    );
    UICtrl.setSearchAreaToggle(gridManager);
}

//添加按钮
function addHandler() {
    UICtrl.showAjaxDialog({url: web_app.name + '/exceptionReasonTypeDetail/showInsertExceptionReasonTypeDetail.load',
        ok: insert, close: dialogClose,width:750,title:'新增'
    });
}

//编辑按钮
function updateHandler(id){
    if(!id){
        var id = DataUtil.getUpdateRowId(gridManager);
        if (!id){ return; }
    }
    UICtrl.showAjaxDialog({url: web_app.name + '/exceptionReasonTypeDetail/showUpdateExceptionReasonTypeDetail.load',
        param:{id:id},
        ok: update,
        width:750,
        title:'修改',
        close: dialogClose
    });
}

//删除按钮
function deleteHandler(){
    DataUtil.del({action:'exceptionReasonTypeDetail/deleteExceptionReasonTypeDetail.ajax',
        gridManager:gridManager,
        onSuccess:function(){
            reloadGrid();
        }
    });

}

function insert() {
    var id=$('#id').val();
    if(id!='') {
        return update();
    }
    var _self=this;
    $('#submitForm').ajaxSubmit({url: web_app.name + '/exceptionReasonTypeDetail/savedExceptionReasonTypeDetail.ajax',
        param:{},
        success: function(id) {
            $('#id').val(id);
            _self.close();
            gridManager.loadData();
            refreshFlag = true;
        }
    });
}

//编辑保存
function update(){
    var _self=this;
    $('#submitForm').ajaxSubmit({url: web_app.name + '/exceptionReasonTypeDetail/savedExceptionReasonTypeDetail.ajax',
        param:{},
        success: function() {
            refreshFlag = true;
            _self.close();
            gridManager.loadData();
        }
    });
}

//关闭对话框
function dialogClose(){
    if(refreshFlag){
        reloadGrid();
        refreshFlag=false;
    }
}

//从EXCEL导入数据
function impExcelDataHandler(){
    ExcelImpManager.showImpDialog('导入', 'exceptionReasonTypeDetail', Public.getUUID());
}


function reloadGrid() {
    var params = $("#queryMainForm").formToJSON();
    UICtrl.gridSearch(gridManager, params);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
}


