var gridManager = null,canEdit = true;

$(document).ready(function () {
    initialize();
    loadGrid();
    bindEvent();
});
function initialize(){
    var mainFileTable = $('#sapDullInfoList').fileList();
    mainFileTable.find('table').css({
        borderTopWidth : 0
    });
    $('#sapDullInfoList').fileList({
        bizId : $("#attbizId").val()
    });
    UICtrl.layout("#layout", {leftWidth: 3});
    if (isApplyProcUnit()){
        $("#dutyDiv").hide();
        UICtrl.setElRequiredFlag("#dutyPersonName",false);
    }
    if ("audit" == getSubProcUnitId()){
        canEdit = false;
        $("#dutyDiv").show();
        UICtrl.setElRequiredFlag("#dutyPersonName",true);
    }
}

function bindEvent(){
    //工厂
    $('#werksName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "WERKS"}
        },
        onChange: function (value, data) {
            $('#werks').val(data.WERKS);
            $('#werksName').val(data.NAME1);
        }
    });

    $("#dutyPersonName").orgTree({
        filter: "psm", excludePos: 0, param: {orgKindId: "ogn,dpt,pos,psm",orgRoot: "14636F3F48934EE7811768692A0AC5E1"},
        back: {
            text: "#dutyPersonName",
            value : '#dutyPersonId'
        },
        onChange:function(value,data){
            $('#dutyPersonId').val(data.id);
            $('#dutyPersonName').val(data.name);
        }
    });

}


/**
 * 流程引擎回调设置打样的id
 * @param value 打样申请的id
 */
function setId(id) {
    $("#id").val(id);
    var _grid=UICtrl.getGridManager('#maingrid');
    _grid.options.parms.sapDullId = id;
    $('#sapDullInfoList').fileList({
        bizId : id
    });
}

/**
 * 流程引擎获取打样申请id的回掉方法。
 * @return 打样申请的id
 */
function getId() {
    return $("#id").val() || "";
}

function loadGrid() {
    var toolbarOptions =null;
    if (canEdit){
        toolbarOptions = UICtrl.getDefaultToolbarOptions({
            addHandler: function () {
                UICtrl.addGridRow(gridManager);
            },
            deleteHandler: function () {
                var _grid = UICtrl.getGridManager('#maingrid');
                DataUtil.delSelectedRows({
                    action: 'sapDullItem/deleteSapDullItems.ajax',
                    param: {},
                    gridManager: _grid,
                    idFieldName: 'id',
                    onSuccess: function () {
                        reloadGrid();
                    }
                });
            }
            // copyHandler: copyHandler
            // impExcelDataHandler:{id:'impExcelData',img:'fa-table',text:'导入数据',click:impExcelDataHandler},

        });
    }
    //  }
    gridManager = UICtrl.grid("#maingrid", {
        columns: [

            {display: "物料编码", name: "matnr", width: "160", align: "left", type: "string",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "sapMaterialSelect",
                        getParam: function (item) {
                            if (Public.isBlank($('#werks').val())){
                                Public.tip("请先选择工厂！")
                                return false
                            }
                            return {
                                ///  fieldName: "sapMaterialSelect",
                                filterValue: $('#werks').val()
                            }
                        },
                        back: {
                            MATNR: "matnr",
                            MAKTX: "matnrName",
                            LGFSB: "store",
                            LGOBE: "storeName"
                        }
                    },
                }
            },
            {display: "物料名称", name: "matnrName", width: "200", align: "left", type: "string"},

            {display: "库存地点", name: "storeName", width: "140", align: "left", type: "string"},

            {display: "批次", name: "batch", width: "140", align: "left", type: "string",
                editor: {required: false, type: "text"}
                },
            { display: "数量", name: "quantity", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {  type: "text",mask: 'nnnnnn.nn',required: true }
            },
            { display: "呆滞天数", name: "dullDays", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {  type: "text",mask: 'nnnnnn',required: false }
            },
            {
                display: "说明", name: "remark", width: 360, minWidth: 60, type: "string", align: "left",
                editor: {required: false, type: "text"}
            }
        ],
        dataAction: "server",
        url: web_app.name + '/sapDullItem/querySapDullItems.ajax',
        pageSize: 10,
        usePager: true,
        parms:{sapDullId:getId()},
        toolbar: toolbarOptions,
        enabledEdit: canEdit,
        width: "100%",
        height: "80%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
    });
    UICtrl.setSearchAreaToggle(gridManager);
}


function reloadGrid() {
    gridManager.loadData();
}

function getExtendedData(processAction) {
//回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
//不验证
        $('#submitForm').attr('check', false);
    }
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#maingrid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: true
        });

        if (!datas) {
            return false;
        }
        extendedData.items = Public.encodeJSONURI(datas);
    }
    return extendedData;
}

//UICtrl中校验是否允许编辑
function businessJudgmentUnit() {
    var isApply='';

    if( typeof(isApplyProcUnit) =='function'){
        isApply=isApplyProcUnit();
    }
    if (isApply){
        return true
    }else {
        var subProcUnitId = getSubProcUnitId();
        if (subProcUnitId === "audit"){
            UICtrl.setEditable($("#submitForm"));
            UICtrl.disable($("#werksName"));
            UICtrl.disable($("#remark"));
            UICtrl.setElRequiredFlag("#dutyPersonName",true);
            return true
        }
    }
    return false;
}
