var gridManager = null;

$(document).ready(function () {
    initialize();
    loadGrid();
    bindEvent();
});
function initialize(){
    UICtrl.layout("#layout", {leftWidth: 3});

    if (!isApplyProcUnit()){
        $("#button").hide()
    }
}

function doQuery() {
    if (Public.isBlank($("#bukrs").val())){
        Public.tip("请选择公司代码");
        return false
    }
    if (Public.isBlank($("#customer").val())){
        Public.tip("请选择客户名称");
        return false
    }
    gridManager.loadData();
}

function doClear(){
    $('#bukrs').val("");
    $('#bukrsName').val("");
    $('#customer').val("");
    $('#name').val("");
}

function bindEvent(){
    $('#bukrsName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "BUKRS"}
        },
        onChange: function (value, data) {
            $('#bukrs').val(data.BUKRS);
            $('#bukrsName').val(data.BUTXT);
            var _grid=UICtrl.getGridManager('#maingrid');
            _grid.options.parms.bukrs = data.BUKRS;
        }
    });

    $('#name').searchbox({
        type: "system", name: "getCusAndSuppliers",
        getParam: function (item) {
            if (Public.isBlank($("#bukrs").val())){
                Public.tip("请先选择公司名称");
                return false
            }
            return {
                ZEP_BPTYPE: 'D',
                BUKRS: $("#bukrs").val()
            }
        },
        onChange: function (value, data) {
            $('#customer').val(data.PARTNER);
            $('#name').val(data.NAME_ORG1);
            var _grid=UICtrl.getGridManager('#maingrid');
            _grid.options.parms.customer = data.PARTNER;
        }
    });

    $('input[name="xblock"]').change(function () {
        var _grid=UICtrl.getGridManager('#maingrid');
        if ($(this).is(':checked')) {
            _grid.options.parms.xblock = 'X';
        }else {
            _grid.options.parms.xblock = '';
        }
    });
}

function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: getGridColumns(),
        dataAction: "server",
        url: web_app.name + '/customerDelayPay/queryCustomerDelayPayItems.ajax',
        pageSize: 50,
        usePager: true,
        parms: {
            customerDelayPayId:getId(),
            bukrs: $("#bukrs").val(),
            customer: $("#customer").val(),
            xblock: $("#xblock").val()
        },
        toolbar: toolbarOptions,
        enabledEdit: false,
        width: "100%",
        height: "95%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function getGridColumns(){
    var columns=[];
    columns.push({
        display: "到期日期", name: "netdt", width: 150, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "延期次数", name: "zextnd", width: 100, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "公司代码", name: "compCode", width: 100, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "客户编号", name: "customer", width: 100, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "名称", name: "name", width: 200, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "抬头文本", name: "bktxt", width: 200, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "付款参考 /请款单号", name: "kidno", width: 140, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "催款层次", name: "dunnLevel", width: 150, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "上次催款日期", name: "lastDunn", width: 150, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "会计年度", name: "fiscYear", width: 150, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "会计期间", name: "fisPeriod", width: 150, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "凭证编号", name: "docNo", width: 200, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "行项目号", name: "itemNum", width: 100, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "凭证日期", name: "docDate", width: 150, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "交易金额", name: "amtDoccur", width: 100, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "交易货币", name: "currency", width: 100, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "本币金额", name: "lcAmount", width: 100, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "本币", name: "locCurrcy", width: 100, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "项目文本", name: "itemText", width: 200, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "付款条件代码", name: "pmnttrms", width: 100, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "起算日期", name: "blineDate", width: 150, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "扣单应收项次", name: "xblock", width: 100, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "账期", name: "zbd1t", width: 100, minWidth: 60, type: "string", align: "left",
    },)
    columns.push({
        display: "到期天数", name: "dsctDays1", width: 100, minWidth: 60, type: "string", align: "left",
    },)
    return columns;
}

/**
 * 流程引擎回调设置打样的id
 * @param value 打样申请的id
 */
function setId(id) {
    $("#id").val(id);

    var _grid=UICtrl.getGridManager('#maingrid');
    _grid.options.parms.customerDelayPayId = id;
}

/**
 * 流程引擎获取id的回掉方法。
 * @return id
 */
function getId() {
    return $("#id").val() || "";
}

function reloadGrid() {
    gridManager.loadData();
}

function getExtendedData(processAction) {
//回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
//不验证
        $('#submitForm').attr('check', false);
    }
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#maingrid');
    if (_grid) {
        // var datas = DataUtil.getGridData({
        //     gridManager: _grid,
        //     isAllData: true
        // });
        var datas = gridManager.getSelectedRows();
        if (!datas) {
            return;
        }
        if (!datas) {
            return false;
        }
        extendedData.items = Public.encodeJSONURI(datas);
    }
    return extendedData;
}

