var gridManager = null;

$(document).ready(function () {

    initializateUI();
    loadGrid();
})
function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadGrid() {

    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addCostReimbursement: {id:'costReimbursement',img:'fa-cog',text:'添加付款申请(无PO)',click:function(){
                addCostReimbursement();
            }},
    });
    gridManager = UICtrl.grid("#costReimbursementListGrid", {
        columns: [
            {display: "EP付款申请类别", name: "zepFtype", width: 60, minWidth: 60, type: "string", align: "left"},
            {display: "EP付款申请类别名称", name: "zepFtypename", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "公司代码", name: "bukrs", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "公司代码名称", name: "butxt", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "EP部门代码", name: "zepDepart", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "EP部门名称", name: "zepDepartname", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "EP流程申请人代码", name: "zepAppli", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "EP流程申请人", name: "zepAppliname", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "付款申请创建日期", name: "zepFcrdate", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "EP流程单号", name: "zepNo", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "付款申请内容", name: "zepTxt", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "填报日期", name: "fillinDate", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "审批状态", name: "statusTextView", width: 100, minWidth: 60, type: "string", align: "left"},

        ],
        dataAction: "server",
        url: web_app.name + '/sapCostReimbursement/slicedSapCostReimbursementList.ajax',
        parms:{zepFtype:"H"},
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        sortName:'fillinDate',
        sortOrder: 'desc',
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id,data.zepFtype);
        }

    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}


//重写DataUtil的getUpdateRowId函数、它默认取行的id列
DataUtil.getUpdateRowId = function (gridManager) {
    var result = DataUtil.getUpdateRow(gridManager);
    if (result) {
        return result.proofingMakeId;
    }
    return result;
}

function addCostReimbursement() {
    UICtrl.addTabItem({
        tabid: 'payApplyNoPO',
        text: "付款申请(无PO)",
        url: web_app.name + '/sapCostReimbursement/forwardCostReimbursement.job?type=payNoPo'
    });
}

function addBorrowApply(){
    UICtrl.addTabItem({
        tabid: 'borrowApply',
        text: "借款申请单",
        url: web_app.name + '/sapCostReimbursement/forwardCostReimbursement.job?type=borrow'
    });
}
function addAdvancePayment(){
    UICtrl.addTabItem({
        tabid: 'advanceApply',
        text: "预付款申请单",
        url: web_app.name + '/sapCostReimbursement/forwardCostReimbursement.job?type=advance'
    });
}

function addPayApply(){
    UICtrl.addTabItem({
        tabid: 'payApply',
        text: "付款申请单",
        url: web_app.name + '/sapCostReimbursement/forwardCostReimbursement.job?type=pay'
    });
}

function addRefundApply(){
    UICtrl.addTabItem({
        tabid: 'refundApply',
        text: "客户退款申请单",
        url: web_app.name + '/sapCostReimbursement/forwardCostReimbursement.job?type=refund'
    });
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'sapCostReimbursement/deleteStatsIndicators.ajax',
        gridManager: gridManager, idFieldName: 'id',
        onSuccess: function () {
            reloadGrid();
        }
    });
}



function doView(id,zepFtype) {
    var title="费用报销详情";
    if (zepFtype=="E"){
        title="客户退款申请详情";
    }
    if (zepFtype=="H"){
        title="付款申请(无PO)详情";
    }
    if (zepFtype=="B"){
        title="员工借款申请详情";
    }
    if (zepFtype=="D"){
        title="预付款申请详情";
    }
    if (zepFtype=="C"){
        title="付款申请详情";
    }
    UICtrl.addTabItem({
        tabid: 'showCostReimbursement'+id,
        text: title,
        url: web_app.name + '/sapCostReimbursement/showSapCostReimbursement.job?bizId='+id+"&isDetailPage=true"
    });
}

// function sendSapData(bizId){
//     Public.ajax(web_app.name + '/sapStatsIndicators/againSendSapDate.ajax',{bizId:bizId},function (data){
//         reloadGrid();
//     })
// }