var gridManager = null, refreshFlag = false;
$(document).ready(function () {
        initUI();
        initGrid();
    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function initGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({

    });

    gridManager = UICtrl.grid('#belnrgrid', {
            columns: [
                {
                    display: "采购发票号", name: "BELNR2", width: 120, minwidth: 120, type: "string", align: "left",
                },
                //
                {
                    display: "", name: "GJAHR", width: 120, minwidth: 120, type: "string", align: "left", hide:true,
                },
                {
                    display: "实体发票号", name: "ZZINVCNR", width: 300, minwidth: 120, type: "string", align: "left",
                },
                {
                    display: "对账单号", name: "XBLNR", width: 150, minwidth: 120, type: "string", align: "left",
                },
                {
                    display: "币别", name: "WAERS", width: 120, minwidth: 120, type: "string", align: "left",
                },
                {
                    display: "汇率", name: "KURSF", width: 120, minwidth: 120, type: "string", align: "left",
                },
                {
                    display: "含税金额", name: "KZWI1", width: 120, minwidth: 120, type: "money", align: "left",
                },
                {
                    display: "含税金额（本位币）", name: "KZWI11", width: 120, minwidth: 120, type: "money", align: "left",
                    render:function(item){
                        var money = 0;
                        if (item.WAERS === "CNY"){
                            money=item.KZWI1;
                        }else {
                            money=MathUtil.mul(item.KZWI1,item.KURSF);
                        }
                        return item.KZWI11 = money;
                    }
                }

            ],
            dataAction: 'server',
            url: web_app.name + '/sapCostReimbursement/getPartnerInvs.ajax?',
            parms: {
                zepFtype:"C",
                bukrs:$("#bukrs").val(),
                partner:$("#partner").val()
            },
            toolbar: toolbarOptions,
            width: '99.8%',
            height: 400,
            pageSize: 20,
            heightDiff: -4,
            sortName: 'num',
            sortOrder: 'asc',
            checkbox: true,
            usePager: false,
            rownumbers: true,
            enabledEdit: true,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            enableObjectBag: true,
        }
    );
    UICtrl.setSearchAreaToggle(gridManager);
}

function reloadDetailGrid() {
    gridManager.loadData();
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
    reloadDetailGrid();
}

