var gridManager = null;

$(document).ready(function () {
    initUI();
    loadGrid();
})
function initUI() {
    UICtrl.initDefaultLayout();

}


function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        deleteHandler:{id:'deleteHandler',img:'fa-cloud-delete',text:'完成订单',click:deleteHandler},
        exportExcelHandler:exportExcelHandler,

    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "客供料", name: "matnr", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "客供料名称", name: "maktx", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "期初日期", name: "pertr", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "订单开始日期", name: "psttr", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "订单完成日期", name: "pedtr", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "订货数量", name: "gsmng", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "单位", name: "meins", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "计划订单", name: "plnum", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "销售订单", name: "kdauf", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "行项次", name: "kdpos", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "跟单员", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "生产订单", name: "aufnr", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "客户名称", name: "kunnrName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "是否完成", name: "closedTextView", width: 100, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/clientMaterials/slicedClientMaterialsList.ajax',
        parms: {
            plnum: $("#plnum").val()
        },
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function deleteHandler(){
    var row = gridManager.getSelectedRow();
    if (!row) {
        return;
    }
    if (row.closed == '1') {
        Public.tip('订单已完成！');
        return;
    }
    Public.ajax(web_app.name + '/clientMaterials/deleteClientMaterials.ajax', {row:$.toJSON(row)}, function () {
    });
}

//导出Excel
function exportExcelHandler() {
    var date = Public.formatDate(new Date(),`%Y%M%D`);
    UICtrl.gridExport(gridManager,{fileName:"客供料通知"+date});
}





