var detailGridManager = null, refreshFlag = false;
$(document).ready(function () {
    $("#ok").hide();
    initUI();
    loadDetailGrid();
    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function loadDetailGrid() {
    var toolbarOptions = null;
    // 表格
    detailGridManager = UICtrl.grid("#detailGrid", {
        gridManager: null,
        columns: [
            {display: "项次", name: "detailNo", width: 60, minWidth: 60, type: "String", align: "left",},
            {display: "销售单号", name: "saleNo", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "销售项次", name: "saleDetailNo", width: 60, minWidth: 60, type: "String", align: "left",},
            {display: "订单类型", name: "orderType", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "验收日期", name: "acceptDate", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "验收单号", name: "acceptNo", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "审核销售订单日", name: "auditDate", width: 140, minWidth: 60, type: "string", align: "left",},
            {display: "客户单号", name: "customNo", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "产品类别", name: "productCategory", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "产品编码", name: "productCode", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "产品名称", name: "productName", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "指令号", name: "orderNo", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "型体配色", name: "color", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "单位（客户）", name: "customUnit", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "请款量", name: "applyNum", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "单价", name: "price", width: 100, minWidth: 60, type: "String", align: "left",},
            //{display: "是否客户确认单价", name: "customerConfirm", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "单重", name: "onePrice", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "实际金额", name: "realAmount", width: 100, minWidth: 60, type: "String", align: "left",},
            //{display: "应收金额", name: "receivableAmount", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "请款重量", name: "applyWeight", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "备注", name: "remark", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "单价折扣%", name: "priceDiscount", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "单价折后金额", name: "priceDiscountAmount", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "是否扣款%", name: "isDeduction", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "是否增款%", name: "isAdd", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "产品编码（客户）", name: "customerProductCode", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "产品名称（客户）", name: "customerProductName", width: 100, minWidth: 60, type: "String", align: "left",},
            {display: "跟单员", name: "salesman", width: 100, minWidth: 60, type: "String", align: "left",},
        ],
        dataAction: "server",
        url: web_app.name + '/cashSettlementUnPayItem/getItemDetailsByAdvanceReceiptNo.ajax',
        parms: {advanceReceiptNo: $("#advanceReceiptNo").val()},
        pageSize: 20,
        usePager: true,
        sortName: "detailNo",
        sortOrder: "asc",
        toolbar: toolbarOptions,
        enabledEdit: false,
        width: "98%",
        height: "300px",
        heightDiff: -8,
        checkbox: false,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
    });
    UICtrl.setSearchAreaToggle(detailGridManager);
}

function reloadDetailGrid() {
    detailGridManager.loadData();
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(detailGridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
}

