var gridManager = null;

$(document).ready(function () {
    initUI();
    loadGrid();
})
function initUI() {
    UICtrl.initDefaultLayout();
}

function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        productAddHandler: {id:'productAddHandler',img:'fa-cog',text:'成品变更',click:function(){
                productAddHandler();
            }},
        materialAddHandler: {id:'materialAddHandler',img:'fa-cog',text:'原材料变更',click:function(){
                materialAddHandler();
            }},
        exportExcelHandler: function () {
            UICtrl.gridExport(gridManager);
        },
        //updateHandler: doUpdate,
        printHandler: {
            id: 'print', text: '打印', img:'fa-clipboard', click: function(){
                printHandler();
            }
        },
        copyHandler:{
            id: 'copyHandler', text: "复制", img:'fa-clipboard', click: function(){
                copyQualityInfoRecord();
            }
        }
    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "审批状态", name: "statusTextView", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "创建日期", name: "fillinDate", width: 120, minWidth: 60, type: "date", align: "left"},
            {display: "序号", name: "changeNo", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "单据编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "变更事项", name: "changeMatter", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "品牌名称", name: "brandName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "产品代号", name: "pd", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "产品名称", name: "productName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "变更类型", name: "reasonForChangeTextView", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "成品变更原因", name: "reasonDesc", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "原材料变更原因", name: "materialReasonForChangeTextView", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "申请人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "状态码", name: "code", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "消息", name: "msg", width: 300, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/epChangeForm/slicedEpChangeFormList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        sortName: 'fillinDate',
        sortOrder: 'desc',
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function productAddHandler() {
    UICtrl.addTabItem({
        tabid: 'epProductChangeForm',
        text: "新增成品变更申请/通知单",
        url: web_app.name + '/epChangeForm/forwardEpChangeFormDetail.job?type=product'
    });
}

function materialAddHandler() {
    UICtrl.addTabItem({
        tabid: 'epMaterialChangeForm',
        text: "新增原材料变更申请/通知单",
        url: web_app.name + '/epChangeForm/forwardEpChangeFormDetail.job?type=material'
    });
}

function doView(id) {
    UICtrl.addTabItem({
        tabid: 'epChangeForm'+id,
        text: "查看变更申请/通知单",
        url: web_app.name + '/epChangeForm/showEpChangeFormDetail.job?bizId='+id+"&isReadOnly=true"
    });
}

function doUpdate() {
    var row = DataUtil.getUpdateRow(gridManager);
    if (!row) {
        return;
    }
    UICtrl.addTabItem({
        tabid: 'epChangeForm'+row.id,
        text: "修改变更申请/通知单",
        url: web_app.name + '/epChangeForm/showEpChangeFormDetail.job?bizId='+row.id
    });
}

function printHandler(){
    var row = DataUtil.getUpdateRow(gridManager);
    if (!row) {
        return;
    }
    // if (row.status != 3){
    //     Public.tip("请审批完成再打印!");
    //     return;
    // }
    var url='/epChangeForm/print.load';
    Public.openPostWindow(web_app.name+url,{id :row.id});
}

function copyQualityInfoRecord(){
    var row = gridManager.getSelectedRow();
    if (!row) {
        return;
    }
    UICtrl.addTabItem({
        tabid: 'epChangeForm'+row.id,
        text: '新增变更申请/通知单',
        url: web_app.name + '/epChangeForm/copyEpChangeForm.job?id=' + row.id
    });
}
