package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 产品打样排版参数配置
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "product_published_conf")
public class ProductPublishedConf implements Serializable {

	/**
	 * 排版参数配置ID
	 */
	@Id
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_published_conf_id", nullable = false)
	private BigDecimal productPublishedConfId;

	/**
	 * 产品ID
	 */
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_id", nullable = true)
	private BigDecimal productId;

	/**
	 * 模数
	 */
	@Column(name = "modulus", nullable = true)
	private Integer modulus;

	/**
	 * 行数
	 */
	@Column(name = "row_num", nullable = true)
	private Integer rowNum;

	/**
	 * 列数
	 */
	@Column(name = "column_num", nullable = true)
	private Integer columnNum;

	/**
	 * 搭版数
	 */
	@Column(name = "contact_num", nullable = true)
	private Integer contactNum;

	/**
	 * 行双刀位(单位mm)
	 */
	@Column(name = "row_double_blade", nullable = true)
	private Double rowDoubleBlade;

	/**
	 * 列双刀位(单位mm)
	 */
	@Column(name = "column_double_blade", nullable = true)
	private Double columnDoubleBlade;

	/**
	 * 派工倍数
	 */
	@Column(name = "dispatch_multiple", nullable = true)
	private Integer dispatchMultiple;

	/**
	 * 印张长度(单位cm)
	 */
	@Column(name = "sheet_length", nullable = true)
	private Double sheetLength;

	/**
	 * 印张宽度(单位cm)
	 */
	@Column(name = "sheet_width", nullable = true)
	private Double sheetWidth;

	/**
	 * 产品印张设置(product_sheet_conf)
	 */
	@Column(name = "product_sheet_conf", nullable = true, length = 32)
	private String productSheetConf;

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;
		ProductPublishedConf that = (ProductPublishedConf) o;
		return new EqualsBuilder().append(productPublishedConfId, that.productPublishedConfId).append(productId, that.productId).append(modulus, that.modulus).append(rowNum, that.rowNum).append(columnNum, that.columnNum).append(contactNum, that.contactNum).append(rowDoubleBlade, that.rowDoubleBlade).append(columnDoubleBlade, that.columnDoubleBlade).append(dispatchMultiple, that.dispatchMultiple).append(sheetLength, that.sheetLength).append(sheetWidth, that.sheetWidth).append(productSheetConf, that.productSheetConf).isEquals();
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder(17, 37).append(productPublishedConfId).append(productId).append(modulus).append(rowNum).append(columnNum).append(contactNum).append(rowDoubleBlade).append(columnDoubleBlade).append(dispatchMultiple).append(sheetLength).append(sheetWidth).append(productSheetConf).toHashCode();
	}

	public BigDecimal getProductPublishedConfId() {
		return this.productPublishedConfId;
	}
	
	public void setProductPublishedConfId (String  productPublishedConfId) {
		this.productPublishedConfId = (productPublishedConfId == null) || productPublishedConfId.isEmpty() ? null : new BigDecimal(productPublishedConfId);
	}
	
	public BigDecimal getProductId() {
		return this.productId;
	}
	
	public void setProductId (String  productId) {
		this.productId = (productId == null) || productId.isEmpty() ? null : new BigDecimal(productId);
	}
	
	public Integer getModulus() {
		return this.modulus;
	}
	
	public void setModulus(Integer modulus) {
		this.modulus = modulus;
	}
	
	public Integer getRowNum() {
		return this.rowNum;
	}
	
	public void setRowNum(Integer rowNum) {
		this.rowNum = rowNum;
	}
	
	public Integer getColumnNum() {
		return this.columnNum;
	}
	
	public void setColumnNum(Integer columnNum) {
		this.columnNum = columnNum;
	}
	
	public Integer getContactNum() {
		return this.contactNum;
	}
	
	public void setContactNum(Integer contactNum) {
		this.contactNum = contactNum;
	}
	
	public Double getRowDoubleBlade() {
		return this.rowDoubleBlade;
	}
	
	public void setRowDoubleBlade(Double rowDoubleBlade) {
		this.rowDoubleBlade = rowDoubleBlade;
	}
	
	public Double getColumnDoubleBlade() {
		return this.columnDoubleBlade;
	}
	
	public void setColumnDoubleBlade(Double columnDoubleBlade) {
		this.columnDoubleBlade = columnDoubleBlade;
	}
	
	public Integer getDispatchMultiple() {
		return this.dispatchMultiple;
	}
	
	public void setDispatchMultiple(Integer dispatchMultiple) {
		this.dispatchMultiple = dispatchMultiple;
	}
	
	public Double getSheetLength() {
		return this.sheetLength;
	}
	
	public void setSheetLength(Double sheetLength) {
		this.sheetLength = sheetLength;
	}
	
	public Double getSheetWidth() {
		return this.sheetWidth;
	}
	
	public void setSheetWidth(Double sheetWidth) {
		this.sheetWidth = sheetWidth;
	}
	
	public String getProductSheetConf() {
		return this.productSheetConf;
	}
	
	public void setProductSheetConf(String productSheetConf) {
		this.productSheetConf = productSheetConf;
	}
}
