package com.huigou.topsun.base.coderule.application;

import com.huigou.topsun.base.coderule.domain.model.CodeRule;
import com.huigou.topsun.base.coderule.domain.model.CodeRuleKind;
import com.huigou.topsun.base.coderule.domain.query.CodeRuleQueryRequest;

import java.util.Map;


/**
 * 采购编号及合同编号编码规则
 * 
 * @author
 * @date 2018-06-20 15:20
 */
public interface CodeRuleApplication {

    public final String RULE_REG = "\\{(.[^\\{\\}]*)\\}(.*)\\{([0-9])\\}";

    public static final String QUERY_XML_FILE_PATH = "config/topsun/base/codeRule.xml";

    CodeRule getRuleValueAsKind(String orgId, CodeRuleKind kind);

    /**
     * 获取编号
     * 
     * @param orgId
     * @param kind
     * @return
     */
    String getNextCode(String orgId, String purchaseKind, CodeRuleKind kind);

    /**
     * 保存 硬X编号规则表
     * 
     * @author
     * @param params
     */
    String saveCodeRule(CodeRule hxCodeRule);

    /**
     * 加载 硬X编号规则表
     * 
     * @author
     * @return SDO
     */
    CodeRule loadCodeRule(String id);

    /**
     * 查询 硬X编号规则表
     * 
     * @author
     * @return SDO
     */
    Map<String, Object> slicedQueryCodeRule(CodeRuleQueryRequest queryRequest);

}
