var gridManager = null;

$(document).ready(function () {
    initializateUI();
    loadTechnologyListGrid();
});


function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadTechnologyListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addHandler();
        },
        updateHandler: function () {
            updateHandler();
        },
        deleteHandler: deleteHandler,
    });
    gridManager = UICtrl.grid("#sapPriceMasterDataListGrid", {
        columns: [
            {display: "行号", name: "sequence", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "产品物料", name: "matnr", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "价格", name: "kbetr", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "币别", name: "konwaTextView", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "条件单位", name: "kmein", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "有限期自", name: "datab", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "有限截止日", name: "datbi", width: 120, minWidth: 60, type: "string", align: "left"},
            ],
        dataAction: "server",
        url: web_app.name + '/sapPriceMasterData/slicedPriceMasterDataList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'sapPriceMasterDataDetail',
        text: "价格主数据维护",
        url: web_app.name + '/sapPriceMasterData/forwardPriceMasterDataDetail.job'
    })
}

function updateHandler(row) {
    if (!row) {
        row = DataUtil.getUpdateRow(gridManager);
        if (!row) {
            return;
        }
    }
    UICtrl.addTabItem({
        tabid: 'sapPriceMasterDataDetail' + row.id,
        text: "价格主数据维护",
        url: web_app.name + '/sapPriceMasterData/showPriceMasterDataDetail.do?id=' + row.id
    })
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'sapPriceMasterData/deletePriceMasterDataById.ajax',
        gridManager: gridManager, idFieldName: 'id',
        onSuccess: function () {
            reloadGrid();
        }
    });
}
