package com.huigou.topsun.sap.wasteSale.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.wasteSale.application.WasteSaleItemApplication;
import com.huigou.topsun.sap.wasteSale.domain.WasteSaleItem;
import com.huigou.topsun.sap.wasteSale.domain.query.WasteSaleQueryRequest;
import com.huigou.topsun.sap.wasteSale.repository.WasteSaleItemRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/13/19:17
 * @Description:
 */
@Service("wasteSaleItemApplication")
public class WasteSaleItemApplicationImpl extends BaseApplication implements WasteSaleItemApplication {
    @Autowired
    private WasteSaleItemRepository wasteSaleItemRepository;
    @Override
    public void saveWasteSaleItems(String wasteSaleId, List<WasteSaleItem> wasteSaleItems) {
        wasteSaleItems.forEach(wasteSaleItem -> {
            wasteSaleItem.setWasteSaleId(wasteSaleId);
            wasteSaleItemRepository.save(wasteSaleItem);
        });
    }

    @Override
    public Map<String, Object> queryWasteSaleItems(WasteSaleQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getWasteSaleId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "wasteSaleItems");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            wasteSaleItemRepository.delete(id);
        });
    }

    @Override
    public List<WasteSaleItem> findByWasteSaleId(String wasteSaleId) {
        return wasteSaleItemRepository.findByWasteSaleId(wasteSaleId);
    }
}
