package com.huigou.topsun.sap.suppliers.application;

import com.huigou.topsun.sap.nonProdApply.domain.query.NonProdApplyBaseInfoQueryRequest;
import com.huigou.topsun.sap.suppliers.domain.SuppliersBank;
import com.huigou.topsun.sap.suppliers.domain.SuppliersBuyer;
import com.huigou.topsun.sap.suppliers.domain.SuppliersInfo;
import com.huigou.topsun.sap.suppliers.domain.SuppliersPay;
import com.huigou.topsun.sap.suppliers.domain.query.SuppliersBankQueryRequest;
import com.huigou.topsun.sap.suppliers.domain.query.SuppliersBuyerQueryRequest;
import com.huigou.topsun.sap.suppliers.domain.query.SuppliersDataQueryRequest;
import com.huigou.topsun.sap.suppliers.domain.query.SuppliersPayQueryRequest;
import com.huigou.uasp.bpm.FlowBroker;
import com.huigou.util.SDO;
import org.springframework.data.domain.Sort;

import java.util.List;
import java.util.Map;

public interface SuppliersDataApplication {

    String PROCESS_DEFINITION_KEY = "sapSuppliersDataProc";
    String PROCESS_DEFINITION_KEY2 = "sapSuppliersDataModiProc";
    String PROCESS_DEFINITION_KEY3 = "sapSuppliersDataDeleProc";
    String PROCESS_DEFINITION_KEY4 = "sapSuppliersDataExteProc";

    String QUERY_XML_FILE_PATH= "config/topsun/sap/sapSuppliersData/suppliersData.xml";

    Map<String, Object> slicedSuppliersDataQuery(SuppliersDataQueryRequest query);


    SuppliersInfo loadSuppliersDataById(String id);

    Map<String, Object>  loadSuppliersPayDatas(SuppliersPayQueryRequest queryRequest);

    Map<String, Object>  loadSuppliersBuyerDatas(SuppliersBuyerQueryRequest queryRequest);

    Map<String, Object>  loadSuppliersBankDatas(SuppliersBankQueryRequest  queryRequest);
    Map<String, Object>  loadSuppliersItemPeriodDatas(SuppliersBankQueryRequest  queryRequest);
    List<Map<String, Object>>  selectSupplierWaers(String partner);

     void deleteSuppliersDataByIds( List<String> ids);

      List<Map<String, Object>> findDeletedSuppliersDataById(SDO params);

     void deleteSuppliersPaysByIds( List<String> ids);

    void deleteSuppliersBuyerByIds( List<String> ids);
    void deleteSuppliersItemPeriodByIds( List<String> ids);

    void deleteSuppliersBankByIds( List<String> ids);

    List<Map<String, String>> selectSuppliersDatas(String types);

    String checkApprovalStatus(String partner);

    Map<String, String> getSupplierNowItemList(String partner);
}
