package com.huigou.topsun.sap.qualityInfoRecord.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.qualityInfoRecord.application.SapQualityInfoRecordItemApplication;
import com.huigou.topsun.sap.qualityInfoRecord.domain.SapQualityInfoRecordItem;
import com.huigou.topsun.sap.qualityInfoRecord.domain.query.SapQualityInfoRecordQueryRequest;
import com.huigou.topsun.sap.qualityInfoRecord.repository.SapQualityInfoRecordItemRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.uasp.bmp.fn.CodeGenerator;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/02/28/15:40
 * @Description:
 */
@Service("sapQualityInfoRecordItemApplication")
public class SapQualityInfoRecordItemApplicationImpl extends BaseApplication implements SapQualityInfoRecordItemApplication {
    @Autowired
    private SapQualityInfoRecordItemRepository sapQualityInfoRecordItemRepository;
    @Autowired
    private CodeGenerator codeGenerator;
    @Override
    public void saveSapQualityInfoRecordItem(String sapQualityInfoRecordId, List<SapQualityInfoRecordItem> sapQualityInfoRecordItems) {
        sapQualityInfoRecordItems.forEach(sapQualityInfoRecordItem -> {
            sapQualityInfoRecordItem.setSapQualityInfoRecordId(sapQualityInfoRecordId);
            if (StringUtil.isBlank(sapQualityInfoRecordItem.getZqinfno())){
                String nextCode = codeGenerator.getNextCode("zqinfno");
                String zqinfno =  sapQualityInfoRecordItem.getWerks() + "-" + nextCode.replace("-0", "-00");
                sapQualityInfoRecordItem.setZqinfno(zqinfno);
            }
            sapQualityInfoRecordItemRepository.save(sapQualityInfoRecordItem);
        });
    }

    @Override
    public Map<String, Object> querySapQualityInfoRecordItem(SapQualityInfoRecordQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getSapQualityInfoRecordId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "sapQualityInfoRecordItems");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            sapQualityInfoRecordItemRepository.delete(id);
        });
    }

    @Override
    public List<SapQualityInfoRecordItem> findBySapQualityInfoRecordId(String sapQualityInfoRecordId) {
        return sapQualityInfoRecordItemRepository.findBySapQualityInfoRecordId(sapQualityInfoRecordId);
    }

    @Override
    public void save(SapQualityInfoRecordItem sapQualityInfoRecordItem) {
        sapQualityInfoRecordItemRepository.save(sapQualityInfoRecordItem);
    }

    @Override
    public boolean checkQualityInfo(String matnr, String lifnr, Date datbi) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "checkQualityInfo");
        int num = this.sqlExecutorDao
                .queryToInt(queryDescriptor.getSql(), matnr, lifnr, datbi);
        boolean flag = false;
        if ( num > 0){
            flag = true;
        }
        return flag;
    }
}
