package com.huigou.topsun.sap.purchaseApproval.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.nonProdApply.application.NonProdApplyApplication;
import com.huigou.topsun.sap.purchaseApproval.application.SapPurchaseApprovalItemApplication;
import com.huigou.topsun.sap.purchaseApproval.domain.SapPurchaseApprovalItem;
import com.huigou.topsun.sap.purchaseApproval.domain.query.SapPurchaseApprovalItemQueryRequest;
import com.huigou.topsun.sap.purchaseApproval.repository.SapPurchaseApprovalItemRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/01/09/19:20
 * @Description:
 */
@Service
public class SapPurchaseApprovalItemApplicationImpl extends BaseApplication implements SapPurchaseApprovalItemApplication {
    @Resource
    private SapPurchaseApprovalItemRepository sapPurchaseApprovalItemRepository;
    @Resource
    private NonProdApplyApplication nonProdApplyApplication;
    @Override
    public void saveSapPurchaseApprovalItems(String sapPurchaseApprovalId, List<SapPurchaseApprovalItem> sapPurchaseApprovalItems) {
        sapPurchaseApprovalItems.forEach(sapPurchaseApprovalItem -> {
            sapPurchaseApprovalItem.setSapPurchaseApprovalId(sapPurchaseApprovalId);
            sapPurchaseApprovalItemRepository.save(sapPurchaseApprovalItem);
        });
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            sapPurchaseApprovalItemRepository.delete(id);
        });
    }

    @Override
    public Map<String, Object> querySapPurchaseApprovalItems(SapPurchaseApprovalItemQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getSapPurchaseApprovalId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "sapPurchaseApprovalItems");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
            List<Map<String, Object>> mapList = (List<Map<String, Object>>) map.get("Rows");
            mapList.forEach(m->{
                String matnr = (String)m.get("matnr");
                String werks = (String)m.get("werks");
                String maktxRemZh = nonProdApplyApplication.getMaktxRemZhByMatnrAndWerks(matnr, werks);
                m.put("maktxRemZh", maktxRemZh);
            });
        }
        return map;
    }

    @Override
    public List<SapPurchaseApprovalItem> querySapPurchaseApprovalItems(String sapPurchaseApprovalId) {
        return sapPurchaseApprovalItemRepository.findBySapPurchaseApprovalId(sapPurchaseApprovalId);
    }
}
