package com.huigou.topsun.sap.productScrapApply.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.productScrapApply.application.ProductScrapApplyItemApplication;
import com.huigou.topsun.sap.productScrapApply.domain.ProductScrapApplyItem;
import com.huigou.topsun.sap.productScrapApply.domain.query.ProductScrapApplyQueryRequest;
import com.huigou.topsun.sap.productScrapApply.repository.ProductScrapApplyItemRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/07/09/15:40
 * @Description:
 */
@Service("productScrapApplyItemApplication")
public class ProductScrapApplyItemApplicationImpl extends BaseApplication implements ProductScrapApplyItemApplication {
    @Autowired
    private ProductScrapApplyItemRepository productScrapApplyItemRepository;
    @Override
    public void saveProductScrapApplyItems(String productScrapApplyId, List<ProductScrapApplyItem> productScrapApplyItems) {
        for (ProductScrapApplyItem productScrapApplyItem : productScrapApplyItems) {
            productScrapApplyItem.setProductScrapApplyId(productScrapApplyId);
        }
        productScrapApplyItemRepository.save(productScrapApplyItems);
    }

    @Override
    public void deleteByIds(List<String> ids) {
        List<ProductScrapApplyItem> itemList = productScrapApplyItemRepository.findAll(ids);
        productScrapApplyItemRepository.delete(itemList);
    }

    @Override
    public Map<String, Object> queryProductScrapApplyItems(ProductScrapApplyQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getProductScrapApplyId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "productScrapApplyItems");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public List<ProductScrapApplyItem> queryProductScrapApplyItems(String productScrapApplyId) {
        return productScrapApplyItemRepository.findByProductScrapApplyId(productScrapApplyId);
    }
}
