package com.huigou.topsun.sap.produceMaterialApply.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.produceMaterialApply.application.ProduceMaterialApplyApplication;
import com.huigou.topsun.sap.produceMaterialApply.domain.ProduceMaterialApply;
import com.huigou.topsun.sap.produceMaterialApply.domain.query.ProduceMaterialApplyQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/05/31/15:07
 * @Description:
 */
@Controller
@ControllerMapping("/produceMaterialApply")
public class ProduceMaterialApplyController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/produceMaterialApply/";
    }

    @Resource
    private ProduceMaterialApplyApplication produceMaterialApplyApplication;

    public String forwardProduceMaterialApplyList(){
        return forward("produceMaterialApplyList");
    }

    public String slicedProduceMaterialApplyList(){
        SDO sdo = this.getSDO();
        ProduceMaterialApplyQueryRequest queryRequest = sdo.toQueryRequest(ProduceMaterialApplyQueryRequest.class);
        Map<String, Object> map = produceMaterialApplyApplication.slicedProduceMaterialApplyList(queryRequest);
        return toResult(map);
    }

    public String forwardProduceMaterialApplyDetail(){
        this.putAttribute("processDefinitionKey", ProduceMaterialApplyApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        ProduceMaterialApply produceMaterialApply = new ProduceMaterialApply();
        produceMaterialApply.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        produceMaterialApply.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("produceMaterialApplyDetail",produceMaterialApply);
    }

    public String showProduceMaterialApplyDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        ProduceMaterialApply produceMaterialApply = produceMaterialApplyApplication.findProduceMaterialApplyById(id);
        return forward("produceMaterialApplyDetail",produceMaterialApply);
    }
}
