package com.huigou.topsun.sap.processQuotedPrice.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/10/30/13:47
 * @Description: 工序报价
 */
@Data
@Entity
@Table(name = "sap_process_quoted_price")
public class ProcessQuotedPrice extends FlowBillAbstractEntity {
    /**
     * 供应商
     */
    @Column(name = "supplier")
    private String supplier;

    @Column(name = "supplier_name")
    private String supplierName;

    /**
     * 报价日期
     */
    @Column(name = "quoted_price_date")
    private Date quotedPriceDate;

    /**
     * 支付方式
     */
    @Column(name = "pay_method")
    private String payMethod;

    /**
     * 币别
     */
    @Column(name = "currency")
    private String currency;

    /**
     * 币别描述
     */
    @Column(name = "currency_name")
    private String currencyName;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 工序报价类别
     * normal 常规
     * proofing 打样
     */
    @Column(name = "process_quoted_type")
    private String processQuotedType;

    @Override
    protected String getCodeRuleId() {
        return "processQuotedPrice";
    }
}
