package com.huigou.topsun.sap.permit.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * SAP放行条
 *
 * @TableName sap_permit_item
 */
@Table(name = "sap_permit_item")
@Entity
@Data
public class SapPermitItem extends AbstractEntity {
    /**
     * SAP放行条id
     */
    @Column(name = "sap_permit_id")
    private String sapPermitId;

    /**
     * 携带物名称
     */
    @Column(name = "belongings")
    private String belongings;

    /**
     * 数量
     */
    @Column(name = "quantity")
    private BigDecimal quantity;

    /**
     * 单位
     */
    @Column(name = "unit")
    private String  unit;
    /**
     * 单位名称
     */
    @Column(name = "unit_name")
    private String  unitName;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * SAP采购订单
     */
    @Column(name = "ebeln")
    private String ebeln;

    /**
     * 物料编码
     */
    @Column(name = "matnr")
    private String matnr;

    /**
     * 供应商名称
     */
    @Column(name = "lifnr_name")
    private String lifnrName;

}