package com.huigou.topsun.sap.nonProducePick.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/13/9:33
 * @Description: SAP非生产性领料申请与发料过账
 */
@Data
@Entity
@Table(name = "sap_non_produce_pick")
public class NonProducePick extends FlowBillAbstractEntity {
    /**
     * 工厂
     */
    @Column(name = "WERKS")
    private String werks;

    @Column(name = "WERKS_NAME")
    private String werksName;

    /**
     * 成本中心
     */
    @Column(name = "KOSTL")
    private String kostl;

    @Column(name = "KOSTL_NAME")
    private String kostlName;

    /**
     * 内部订单
     */
    @Column(name = "AUFNR")
    private String aufnr;

    @Column(name = "AUFNR_NAME")
    private String aufnrName;

    @Column(name = "type")
    private String type;

    @Column(name = "message")
    private String message;

    /**
     * 是否冲销  1：是  0：否
     */
    @Column(name = "is_charge_off")
    private String isChargeOff;

    @Override
    protected String getCodeRuleId() {
        return "nonProducePick";
    }
}
